/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.skyscreamer.yoga.annotations.Core;
import org.skyscreamer.yoga.annotations.ExtraField;
import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.selector.ExtraFieldProperty;
import org.skyscreamer.yoga.selector.MapSelector;
import org.skyscreamer.yoga.selector.PojoProperty;
import org.skyscreamer.yoga.selector.Property;

public class CoreSelector
extends MapSelector {
    private EntityConfigurationRegistry _entityConfigurationRegistry = new DefaultEntityConfigurationRegistry();
    protected ConcurrentHashMap<Class<?>, Collection<Property>> allCoreFields = new ConcurrentHashMap();

    public CoreSelector(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    public CoreSelector() {
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    protected Collection<Property> getRegisteredFieldCollection(Class<?> instanceType) {
        return this.getProperties(instanceType, this.descriptors);
    }

    private Collection<Property> getProperties(Class<?> instanceType, ConcurrentHashMap<Class<?>, Collection<Property>> map) {
        Collection<Property> existingProperties;
        Collection<Property> properties = map.get(instanceType);
        if (properties == null && (existingProperties = map.putIfAbsent(instanceType, properties = this.createCoreFieldsCollection(instanceType))) != null) {
            properties = existingProperties;
        }
        return properties;
    }

    private Collection<Property> createCoreFieldsCollection(Class<?> instanceType) {
        ArrayList<Property> response = new ArrayList<Property>();
        List<PropertyDescriptor> readableProperties = PropertyUtil.getReadableProperties(instanceType);
        Collection<String> allowedCoreFields = this.getConfiguredCoreFields(instanceType);
        if (allowedCoreFields == null) {
            for (PropertyDescriptor property : readableProperties) {
                if (!property.getReadMethod().isAnnotationPresent(Core.class)) continue;
                response.add(new PojoProperty(property));
            }
        } else {
            for (PropertyDescriptor property : readableProperties) {
                if (!allowedCoreFields.contains(property.getName())) continue;
                response.add(new PojoProperty(property));
            }
        }
        return response;
    }

    protected Collection<String> getConfiguredCoreFields(Class<?> instanceType) {
        YogaEntityConfiguration<?> entityConfiguration = this.getConfig(instanceType);
        if (entityConfiguration != null) {
            return entityConfiguration.getCoreFields();
        }
        return null;
    }

    private YogaEntityConfiguration<?> getConfig(Class<?> instanceType) {
        return this._entityConfigurationRegistry != null ? this._entityConfigurationRegistry.getEntityConfiguration(instanceType) : null;
    }

    @Override
    public Collection<Property> getAllPossibleFields(Class<?> instanceType) {
        return this.createAllFieldList(instanceType);
    }

    private Collection<Property> createAllFieldList(Class<?> instanceType) {
        TreeMap<String, Property> response = new TreeMap<String, Property>();
        for (PropertyDescriptor property : PropertyUtil.getReadableProperties(instanceType)) {
            response.put(property.getName(), new PojoProperty(property));
        }
        YogaEntityConfiguration<?> entityConfiguration = this.getConfig(instanceType);
        if (entityConfiguration != null) {
            for (Method method : entityConfiguration.getExtraFieldMethods()) {
                String name = method.getAnnotation(ExtraField.class).value();
                response.put(name, new ExtraFieldProperty(name, entityConfiguration, method));
            }
        }
        return response.values();
    }
}

