/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector.parser;

import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.exceptions.ParseSelectorException;
import org.skyscreamer.yoga.selector.CompositeSelector;
import org.skyscreamer.yoga.selector.FieldSelector;
import org.skyscreamer.yoga.selector.MapSelector;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.selector.parser.AliasSelectorResolver;

public abstract class SelectorParser {
    public static final String ALIAS_SELECTOR_PREFIX = "$";
    public static final String HREF = "href";
    public static final String DEFINITION = "definition";
    protected EntityConfigurationRegistry _entityConfigurationRegistry = new DefaultEntityConfigurationRegistry();
    protected AliasSelectorResolver _aliasSelectorResolver;
    protected boolean _disableExplicitSelectors = false;

    protected abstract FieldSelector parse(String var1) throws ParseSelectorException;

    public abstract String getSelectorJavascriptURL();

    public abstract Object getSelectorType();

    public FieldSelector parseSelector(String selectorExpression) throws ParseSelectorException {
        FieldSelector fieldSelector;
        if (selectorExpression == null) {
            return null;
        }
        if (this._disableExplicitSelectors && !selectorExpression.startsWith(ALIAS_SELECTOR_PREFIX)) {
            throw new ParseSelectorException("Explicit selectors have been disabled");
        }
        if (selectorExpression.startsWith(ALIAS_SELECTOR_PREFIX)) {
            selectorExpression = this._aliasSelectorResolver.resolveSelector(selectorExpression);
        }
        if ((fieldSelector = this.parse(selectorExpression)) != null && !fieldSelector.getAllPossibleFields(null).isEmpty()) {
            return fieldSelector;
        }
        return null;
    }

    public Selector parseSelector(String selectorExpression, MapSelector mapSelector) throws ParseSelectorException {
        FieldSelector fieldSelector = this.parseSelector(selectorExpression);
        if (fieldSelector != null) {
            return new CompositeSelector(mapSelector, fieldSelector);
        }
        return mapSelector;
    }

    public void setAliasSelectorResolver(AliasSelectorResolver aliasSelectorResolver) {
        this._aliasSelectorResolver = aliasSelectorResolver;
    }

    public void setDisableExplicitSelectors(boolean disableExplicitSelectors) {
        this._disableExplicitSelectors = disableExplicitSelectors;
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }
}

