/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;

public class DefaultEntityConfigurationRegistry
implements EntityConfigurationRegistry {
    protected Map<Class<?>, YogaEntityConfiguration<?>> _registry = new HashMap();

    public DefaultEntityConfigurationRegistry() {
    }

    public DefaultEntityConfigurationRegistry(YogaEntityConfiguration<?> ... entityConfigurations) {
        this.register(entityConfigurations);
    }

    public DefaultEntityConfigurationRegistry(List<YogaEntityConfiguration<?>> entityConfigurations) {
        this.register(entityConfigurations.toArray(new YogaEntityConfiguration[0]));
    }

    @Override
    public void register(YogaEntityConfiguration<?> ... entityConfigurations) {
        for (YogaEntityConfiguration<?> entityConfiguration : entityConfigurations) {
            Class<?> type = entityConfiguration.getEntityClass();
            if (type == null) {
                throw new IllegalArgumentException("Entity configuration must define an entity class to configure: " + entityConfiguration.getClass().getName());
            }
            this._registry.put(type, entityConfiguration);
        }
    }

    @Override
    public <T> YogaEntityConfiguration<T> getEntityConfiguration(Class<T> clazz) {
        return this._registry.get(clazz);
    }
}

