/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.skyscreamer.yoga.annotations.ExtraField;
import org.skyscreamer.yoga.exceptions.YogaRuntimeException;
import org.skyscreamer.yoga.selector.Property;

public abstract class YogaEntityConfiguration<T> {
    private volatile Class<T> _instanceClass = null;

    public YogaEntityConfiguration() {
        try {
            this._instanceClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            throw new YogaRuntimeException("Unable to initialize class " + this.getClass().getName() + " because " + "entity class could not be determined.  Either specify it in the generic type when extending " + "YogaEntityConfiguration, or explicitly override getEntityClass() with the correct value.");
        }
    }

    public Class<T> getEntityClass() {
        return this._instanceClass;
    }

    public Collection<String> getCoreFields() {
        return null;
    }

    public Collection<Property<T>> getProperties() {
        return null;
    }

    public Collection<String> getSelectableFields() {
        return null;
    }

    public String getURITemplate() {
        return null;
    }

    public List<Method> getExtraFieldMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.isAnnotationPresent(ExtraField.class) || parameterTypes.length != 0 && (parameterTypes.length != 1 || !parameterTypes[0].equals(this.getEntityClass()))) continue;
            result.add(method);
        }
        return result;
    }

    public List<String> getExtraFieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : this.getExtraFieldMethods()) {
            ExtraField extraField = method.getAnnotation(ExtraField.class);
            result.add(extraField.value());
        }
        return result;
    }
}

