/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.listener;

import java.util.concurrent.atomic.AtomicInteger;
import org.skyscreamer.yoga.exceptions.EntityCountExceededException;
import org.skyscreamer.yoga.exceptions.YogaRuntimeException;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.listener.RenderingEventType;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.mapper.YogaRequestContext;

public class CountLimitRenderingListener
implements RenderingListener {
    int maxCount = 0;

    public CountLimitRenderingListener(int maxCount) {
        this.setMaxCount(maxCount);
    }

    public void setMaxCount(int maxCount) {
        if (maxCount <= 0) {
            throw new YogaRuntimeException("CountLimitRenderingListener expects a positive maxCount");
        }
        this.maxCount = maxCount;
    }

    @Override
    public <T> void eventOccurred(RenderingEvent<T> event) {
        if (event.getType() != RenderingEventType.POJO_CHILD) {
            return;
        }
        YogaRequestContext requestContext = event.getRequestContext();
        AtomicInteger counter = (AtomicInteger)requestContext.getProperty("child_counter");
        if (counter == null) {
            counter = new AtomicInteger();
            requestContext.setProperty("child_counter", counter);
        }
        if (counter.incrementAndGet() > this.maxCount) {
            throw new EntityCountExceededException("The maximum count of children: " + this.maxCount + " has been exceeded.");
        }
    }
}

