/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.listener;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.skyscreamer.yoga.annotations.URITemplate;
import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.listener.RenderingEventType;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.model.MapHierarchicalModel;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.uri.URICreator;
import org.skyscreamer.yoga.uri.URIDecorator;
import org.skyscreamer.yoga.util.ValueReader;

public class HrefListener
implements RenderingListener {
    private EntityConfigurationRegistry _entityConfigurationRegistry = new DefaultEntityConfigurationRegistry();
    private ConcurrentHashMap<Class<?>, String> templates = new ConcurrentHashMap();

    public HrefListener() {
    }

    public HrefListener(EntityConfigurationRegistry _entityConfigurationRegistry) {
        this._entityConfigurationRegistry = _entityConfigurationRegistry;
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    public <T> void eventOccurred(RenderingEvent<T> event) throws IOException {
        String url;
        if (event.getType() == RenderingEventType.POJO_CHILD && (url = this.getUrl(event, event.getRequestContext().getUrlSuffix())) != null) {
            ((MapHierarchicalModel)event.getModel()).addProperty("href", url);
        }
    }

    public <T> String getUrl(RenderingEvent<T> event, String suffix) throws IOException {
        String urlTemplate = this.determineTemplate(event.getValueType());
        return urlTemplate != null ? this.getUrl(urlTemplate, suffix, event) : null;
    }

    protected String determineTemplate(Class<?> instanceType) {
        String existing;
        YogaEntityConfiguration<?> entityConfiguration;
        String uriTemplate = this.templates.get(instanceType);
        if (uriTemplate != null) {
            return uriTemplate;
        }
        YogaEntityConfiguration<?> yogaEntityConfiguration = entityConfiguration = this._entityConfigurationRegistry == null ? null : this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
        if (entityConfiguration != null && entityConfiguration.getURITemplate() != null) {
            uriTemplate = entityConfiguration.getURITemplate();
        } else if (instanceType.isAnnotationPresent(URITemplate.class)) {
            uriTemplate = instanceType.getAnnotation(URITemplate.class).value();
        }
        if (uriTemplate != null && (existing = this.templates.putIfAbsent(instanceType, uriTemplate)) != null) {
            uriTemplate = existing;
        }
        return uriTemplate;
    }

    public <T> String getUrl(String uriTemplate, String suffix, RenderingEvent<T> event) {
        String url = this.getUrlVal(uriTemplate, suffix, event);
        return event.getRequestContext().getResponse().encodeURL(url);
    }

    protected <T> String getUrlVal(String uriTemplate, final String suffix, final RenderingEvent<T> event) {
        ValueReader reader = new ValueReader(){

            @Override
            public Object getValue(String propertyName) {
                Property property = event.getSelector().getProperty(event.getValueType(), propertyName);
                return property == null ? null : property.getValue(event.getValue());
            }
        };
        if (suffix != null) {
            return URICreator.getHref(uriTemplate, reader, new URIDecorator(){

                @Override
                public StringBuilder decorate(StringBuilder uri) {
                    return uri.append(".").append(suffix);
                }
            });
        }
        return URICreator.getHref(uriTemplate, reader, new URIDecorator[0]);
    }
}

