/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.listener.RenderingEventType;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.model.ListHierarchicalModel;
import org.skyscreamer.yoga.model.MapHierarchicalModel;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.selector.parser.SelectorParser;

public class YogaRequestContext {
    private final String urlSuffix;
    private final SelectorParser selectorParser;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Collection<RenderingListener> listeners;

    public YogaRequestContext(String urlSuffix, SelectorParser parser, HttpServletRequest request, HttpServletResponse response, RenderingListener ... listeners) {
        this(urlSuffix, parser, request, response, Arrays.asList(listeners));
    }

    public YogaRequestContext(String urlSuffix, SelectorParser parser, HttpServletRequest request, HttpServletResponse response, Collection<RenderingListener> listeners) {
        this.urlSuffix = urlSuffix;
        this.selectorParser = parser;
        this.request = request;
        this.response = response;
        this.listeners = listeners;
    }

    public String getUrlSuffix() {
        return this.urlSuffix;
    }

    public SelectorParser getSelectorParser() {
        return this.selectorParser;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public <T> void emitEvent(RenderingEvent<T> event) throws IOException {
        if (this.listeners == null) {
            return;
        }
        for (RenderingListener renderingListener : this.listeners) {
            renderingListener.eventOccurred(event);
        }
    }

    public <T> void emitEvent(MapHierarchicalModel<?> model, T value, Class<T> type, YogaRequestContext context, Selector selector) throws IOException {
        this.emitEvent(new RenderingEvent<T>(RenderingEventType.POJO_CHILD, model, value, type, context, selector));
    }

    public void emitEvent(ListHierarchicalModel<?> model, Iterable<?> iterable, YogaRequestContext context, Selector selector) throws IOException {
        this.emitEvent(new RenderingEvent(RenderingEventType.LIST_CHILD, model, iterable, iterable.getClass(), context, selector));
    }
}

