/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class CompositeSelector
implements Selector {
    private Selector coreSelector;
    private Selector fieldSelector;

    public CompositeSelector(Selector coreSelector, Selector fieldSelector) {
        this.coreSelector = coreSelector;
        this.fieldSelector = fieldSelector;
    }

    @Override
    public Selector getChildSelector(Class<?> instanceType, String fieldName) {
        Selector fieldSelectorChild = this.fieldSelector.getChildSelector(instanceType, fieldName);
        Selector coreSelectorChild = this.coreSelector.getChildSelector(instanceType, fieldName);
        if (fieldSelectorChild == null) {
            return coreSelectorChild;
        }
        return new CompositeSelector(coreSelectorChild, fieldSelectorChild);
    }

    @Override
    public boolean containsField(Class<?> instanceType, String property) {
        return this.coreSelector.containsField(instanceType, property) || this.fieldSelector.containsField(instanceType, property);
    }

    @Override
    public <T> Property<T> getProperty(Class<T> instanceType, String fieldName) {
        Property<T> property = this.coreSelector.getProperty(instanceType, fieldName);
        return property != null ? property : this.fieldSelector.getProperty(instanceType, fieldName);
    }

    @Override
    public <T> Collection<Property<T>> getSelectedFields(Class<T> instanceType) {
        TreeMap<String, Property<T>> response = new TreeMap<String, Property<T>>();
        Collection<Property<T>> selectedFields = this.coreSelector.getSelectedFields(instanceType);
        for (Property<T> property : selectedFields) {
            response.put(property.name(), property);
        }
        Collection<Property<T>> fieldSelectorChildren = this.fieldSelector.getSelectedFields(instanceType);
        Map<String, Property<T>> allMapFields = this.coreSelector.getAllPossibleFieldMap(instanceType);
        for (Property<T> property : fieldSelectorChildren) {
            Property<T> prop;
            String name = property.name();
            if (response.containsKey(name) || (prop = allMapFields.get(name)) == null) continue;
            response.put(name, prop);
        }
        return response.values();
    }

    @Override
    public <T> Map<String, Property<T>> getAllPossibleFieldMap(Class<T> instanceType) {
        return this.coreSelector.getAllPossibleFieldMap(instanceType);
    }

    @Override
    public boolean isInfluencedExternally() {
        return true;
    }
}

