/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.selector.NamedProperty;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class FieldSelector
implements Selector {
    protected Map<String, FieldSelector> subSelectors = new HashMap<String, FieldSelector>();
    protected EntityConfigurationRegistry _entityConfigurationRegistry;
    private HashMap<String, Property> allFields;

    public FieldSelector(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    @Override
    public FieldSelector getChildSelector(Class<?> instanceType, String fieldName) {
        return this.getSelector(fieldName);
    }

    public FieldSelector getSelector(String fieldName) {
        return this.subSelectors.get(fieldName);
    }

    @Override
    public boolean containsField(Class<?> instanceType, String property) {
        return this.containsField(property);
    }

    @Override
    public <T> Property<T> getProperty(Class<T> instanceType, String fieldName) {
        return this.getAllPossibleFieldMap(instanceType).get(fieldName);
    }

    public boolean containsField(String property) {
        return this.subSelectors.containsKey(property);
    }

    public int getFieldCount() {
        return this.subSelectors.size();
    }

    public void register(String fieldName, FieldSelector subSelector) {
        this.subSelectors.put(fieldName, subSelector);
    }

    @Override
    public <T> Collection<Property<T>> getSelectedFields(Class<T> instanceType) {
        return this.getAllPossibleFieldMap(instanceType).values();
    }

    @Override
    public <T> Map<String, Property<T>> getAllPossibleFieldMap(Class<T> instanceType) {
        if (this.allFields == null) {
            YogaEntityConfiguration<T> entityConfiguration = this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
            Collection<String> selectableFields = entityConfiguration == null ? null : entityConfiguration.getSelectableFields();
            this.allFields = new HashMap();
            for (String name : this.subSelectors.keySet()) {
                if (selectableFields != null && !selectableFields.contains(name)) continue;
                this.allFields.put(name, new NamedProperty(name));
            }
        }
        return this.allFields;
    }

    @Override
    public boolean isInfluencedExternally() {
        return true;
    }
}

