/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.view;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.skyscreamer.yoga.listener.RenderingListenerRegistry;
import org.skyscreamer.yoga.mapper.ResultTraverser;
import org.skyscreamer.yoga.mapper.YogaRequestContext;
import org.skyscreamer.yoga.selector.CoreSelector;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.selector.SelectorResolver;
import org.skyscreamer.yoga.selector.parser.SelectorParser;
import org.skyscreamer.yoga.util.ClassFinderStrategy;
import org.skyscreamer.yoga.util.NameUtil;

public abstract class AbstractYogaView {
    protected ResultTraverser _resultTraverser = new ResultTraverser();
    protected ClassFinderStrategy _classFinderStrategy;
    protected SelectorResolver _selectorResolver = new SelectorResolver();
    protected RenderingListenerRegistry _registry = new RenderingListenerRegistry();

    public void setResultTraverser(ResultTraverser resultTraverser) {
        this._resultTraverser = resultTraverser;
    }

    public void setSelectorParser(SelectorParser selectorParser) {
        this._selectorResolver.setSelectorParser(selectorParser);
    }

    public void setRegistry(RenderingListenerRegistry registry) {
        this._registry = registry;
    }

    public void setSelector(CoreSelector selector) {
        this._selectorResolver.setBaseSelector(selector);
    }

    public void setSelectorResolver(SelectorResolver selectorResolver) {
        this._selectorResolver = selectorResolver;
    }

    public SelectorResolver getSelectorResolver() {
        return this._selectorResolver;
    }

    public void setClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this._classFinderStrategy = classFinderStrategy;
        this._resultTraverser.setClassFinderStrategy(classFinderStrategy);
    }

    public final void render(HttpServletRequest request, HttpServletResponse response, Object value, OutputStream os) throws Exception {
        YogaRequestContext context = new YogaRequestContext(this.getHrefSuffix(), this.getSelectorResolver().getSelectorParser(), request, response, this._registry.getListeners());
        Selector selector = this.getSelectorResolver().getSelector(request);
        this.render(selector, value, context, os);
    }

    protected String getClassName(Object obj) {
        Class<Object> type = this._classFinderStrategy.findClass(obj);
        return NameUtil.getName(type);
    }

    public abstract String getContentType();

    protected abstract void render(Selector var1, Object var2, YogaRequestContext var3, OutputStream var4) throws Exception;

    public abstract String getHrefSuffix();
}

