/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.view;

import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.skyscreamer.yoga.mapper.YogaRequestContext;
import org.skyscreamer.yoga.model.HierarchicalModel;
import org.skyscreamer.yoga.model.XhtmlHierarchyModelImpl;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.view.AbstractYogaView;
import org.skyscreamer.yoga.view.XmlYogaViewUtil;

public class XhtmlSelectorView
extends AbstractYogaView {
    @Override
    public void render(Selector selector, Object value, YogaRequestContext context, OutputStream os) throws IOException {
        DOMElement rootElement = new DOMElement("html");
        this.initHead((Element)rootElement);
        HierarchicalModel<Element> model = this.getModel(value, (Element)rootElement);
        this._resultTraverser.traverse(value, selector, model, context);
        XmlYogaViewUtil.write((Element)rootElement, os);
    }

    protected HierarchicalModel<Element> getModel(Object value, Element rootElement) {
        Element topDiv = rootElement.addElement("body").addElement("div").addAttribute("class", this.getClassName(value));
        return new XhtmlHierarchyModelImpl(topDiv);
    }

    protected void initHead(Element rootElement) {
        Element cssLink = rootElement.addElement("head").addElement("link");
        cssLink.addAttribute("href", "/css/xhtml.css");
        cssLink.addAttribute("rel", "stylesheet");
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public String getHrefSuffix() {
        return "xhtml";
    }
}

