/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.skyscreamer.yoga.exceptions.ParseSelectorException;
import org.skyscreamer.yoga.selector.parser.AliasSelectorResolver;

public class DynamicPropertyResolver
implements AliasSelectorResolver {
    private int _reloadIntervalSeconds = 0;
    private long _nextReloadTime = 0L;
    private Properties _properties = new Properties();
    private InputStream _propertyFile;

    public DynamicPropertyResolver() {
    }

    public DynamicPropertyResolver(InputStream propertyFile) {
        this.setPropertyFile(propertyFile);
    }

    @Override
    public String resolveSelector(String aliasSelectorExpression) throws ParseSelectorException {
        String result;
        long milliseconds;
        if ((this._nextReloadTime == 0L || this._reloadIntervalSeconds > 0) && (milliseconds = System.currentTimeMillis()) > this._nextReloadTime) {
            try {
                this._properties.load(this._propertyFile);
                this._nextReloadTime = milliseconds + (long)(this._reloadIntervalSeconds * 1000);
            }
            catch (IOException e) {
                throw new ParseSelectorException("Could not load property file");
            }
        }
        if ((result = this._properties.getProperty(aliasSelectorExpression)) == null) {
            throw new ParseSelectorException("No selector defined for " + aliasSelectorExpression);
        }
        return result;
    }

    public void setReloadIntervalSeconds(int reloadIntervalSeconds) {
        this._reloadIntervalSeconds = reloadIntervalSeconds;
    }

    public void setPropertyFile(InputStream propertyFile) {
        this._propertyFile = propertyFile;
    }
}

