/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector.parser;

import org.skyscreamer.yoga.exceptions.ParseSelectorException;
import org.skyscreamer.yoga.selector.FieldSelector;
import org.skyscreamer.yoga.selector.parser.ParentheticalSelectorParser;
import org.skyscreamer.yoga.util.ParenthesisUtil;

public class LinkedInSelectorParser
extends ParentheticalSelectorParser {
    public static final String SELECTOR_TYPE = "LinkedIn";
    private static final String LINKEDIN_SELECTOR_JS_URL = "/js/selector.js";
    private static final String EXPLICIT_SELECTOR_PREFIX = ":(";

    @Override
    public String getSelectorJavascriptURL() {
        return LINKEDIN_SELECTOR_JS_URL;
    }

    @Override
    public Object getSelectorType() {
        return SELECTOR_TYPE;
    }

    @Override
    protected FieldSelector parse(String selectorExpression) throws ParseSelectorException {
        if (selectorExpression.equals(":")) {
            return new FieldSelector();
        }
        if (!selectorExpression.startsWith(EXPLICIT_SELECTOR_PREFIX)) {
            String message = "Selector must start with :(";
            throw new ParseSelectorException(message);
        }
        if (ParenthesisUtil.getMatchingParenthesisIndex(selectorExpression, 1) != selectorExpression.length() - 1) {
            throw new ParseSelectorException("Selector must end with a parenthesis");
        }
        String rawSelectorExpression = selectorExpression.substring(2, selectorExpression.length() - 1);
        String openParenthesis = EXPLICIT_SELECTOR_PREFIX;
        return this.parseParentheticalSelector(rawSelectorExpression, openParenthesis);
    }
}

