/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.view;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.skyscreamer.yoga.mapper.YogaRequestContext;
import org.skyscreamer.yoga.model.ArrayStreamingJsonHierarchicalModel;
import org.skyscreamer.yoga.model.HierarchicalModel;
import org.skyscreamer.yoga.model.ObjectStreamingJsonHierarchicalModel;
import org.skyscreamer.yoga.view.AbstractYogaView;

public class StreamingJsonSelectorView
extends AbstractYogaView {
    JsonFactory jsonFactory = new JsonFactory();

    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @Override
    protected void render(Object value, YogaRequestContext context, OutputStream os) throws Exception {
        JsonGenerator generator = this.createGenerator(os);
        HierarchicalModel<JsonGenerator> model = this.createModel(value, generator);
        this._resultTraverser.traverse(value, context.getSelector(), model, context);
        model.getUnderlyingModel().close();
    }

    protected JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.jsonFactory.createJsonGenerator(outputStream);
    }

    protected HierarchicalModel<JsonGenerator> createModel(Object value, JsonGenerator generator) throws IOException, JsonGenerationException {
        if (value instanceof Iterable) {
            return new ArrayStreamingJsonHierarchicalModel(generator);
        }
        return new ObjectStreamingJsonHierarchicalModel(generator);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getHrefSuffix() {
        return "json";
    }
}

