/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.builder;

import java.io.InputStream;
import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.listener.CountLimitRenderingListener;
import org.skyscreamer.yoga.listener.HrefListener;
import org.skyscreamer.yoga.listener.MetadataLinkListener;
import org.skyscreamer.yoga.listener.ModelDefinitionListener;
import org.skyscreamer.yoga.listener.NavigationLinksListener;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.listener.RenderingListenerRegistry;
import org.skyscreamer.yoga.listener.SelectorBuilderListener;
import org.skyscreamer.yoga.listener.UriGenerator;
import org.skyscreamer.yoga.metadata.DefaultMetaDataRegistry;
import org.skyscreamer.yoga.metadata.MetaDataRegistry;
import org.skyscreamer.yoga.selector.SelectorResolver;
import org.skyscreamer.yoga.selector.parser.DynamicPropertyResolver;
import org.skyscreamer.yoga.util.ClassFinderStrategy;
import org.skyscreamer.yoga.util.DefaultClassFinderStrategy;

public class YogaBuilder {
    protected boolean _finalized = false;
    protected ClassFinderStrategy _classFinderStrategy = new DefaultClassFinderStrategy();
    protected RenderingListenerRegistry _registry = new RenderingListenerRegistry(new RenderingListener[0]);
    protected SelectorResolver _selectorResolver;
    protected InputStream _aliasProperties = null;
    protected boolean _createAllLinks = false;
    private MetaDataRegistry _metaDataRegistry;

    public YogaBuilder() {
        this.init();
    }

    protected void init() {
        this._metaDataRegistry = new DefaultMetaDataRegistry();
        this._selectorResolver = new SelectorResolver();
        this._selectorResolver.getBaseSelector().setEntityConfigurationRegistry(new DefaultEntityConfigurationRegistry());
        this._metaDataRegistry.setCoreSelector(this._selectorResolver.getBaseSelector());
        this._metaDataRegistry.setRootMetaDataUrl("/metadata/");
    }

    protected void checkFinalized() {
        if (this._finalized) {
            throw new IllegalStateException("You cannot update builder information after it's been used to generate artifacts");
        }
    }

    public ClassFinderStrategy getClassFinderStrategy() {
        return this._classFinderStrategy;
    }

    public RenderingListenerRegistry getRegistry() {
        return this._registry;
    }

    public SelectorResolver getSelectorResolver() {
        return this._selectorResolver;
    }

    public InputStream getAliasProperties() {
        return this._aliasProperties;
    }

    public boolean isCreateAllLinks() {
        return this._createAllLinks;
    }

    public boolean isEnableYogaMetadata() {
        return !this._metaDataRegistry.getTypes().isEmpty();
    }

    public MetaDataRegistry getMetaDataRegistry() {
        return this._metaDataRegistry;
    }

    public void setClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this.checkFinalized();
        this._classFinderStrategy = classFinderStrategy;
    }

    public void setEntityConfigurations(YogaEntityConfiguration<?> ... entityConfigurations) {
        this.checkFinalized();
        this._selectorResolver.getBaseSelector().getEntityConfigurationRegistry().register(entityConfigurations);
    }

    public void setRegistry(RenderingListenerRegistry registry) {
        this.checkFinalized();
        this._registry = registry;
    }

    public void setAliasProperties(InputStream aliasProperties) {
        this.checkFinalized();
        this._aliasProperties = aliasProperties;
    }

    public void setOutputCountLimit(int countLimit) {
        this.checkFinalized();
        this._registry.addListener(new CountLimitRenderingListener(countLimit));
    }

    public void setCreateYogaLinks(boolean createAllLinks) {
        this.checkFinalized();
        this._createAllLinks = createAllLinks;
    }

    public void setYogaMetaDataRegisteredClasses(Class<?> ... classes) {
        this.checkFinalized();
        this._metaDataRegistry.registerClasses(classes);
    }

    public void setRootMetaDataUrl(String rootMetaDataUrl) {
        this.checkFinalized();
        this._metaDataRegistry.setRootMetaDataUrl(rootMetaDataUrl);
    }

    public void setEnableStarAsAllFields(boolean starAsAll) {
        this.checkFinalized();
        this._selectorResolver.setStarResolvesToAll(starAsAll);
    }

    public YogaBuilder withClassFinderStrategy(ClassFinderStrategy classFinderStrategy) {
        this.setClassFinderStrategy(classFinderStrategy);
        return this;
    }

    public YogaBuilder withRegistryTraverser(RenderingListenerRegistry registry) {
        this.setRegistry(registry);
        return this;
    }

    public YogaBuilder withAliasProperties(InputStream propertyFile) {
        this.setAliasProperties(propertyFile);
        return this;
    }

    public YogaBuilder withOutputCountLimit(int countLimit) {
        this.setOutputCountLimit(countLimit);
        return this;
    }

    public YogaBuilder enableYogaLinks() {
        this.setCreateYogaLinks(true);
        return this;
    }

    public YogaBuilder registerEntityConfigurations(YogaEntityConfiguration<?> ... entityConfigurations) {
        this.setEntityConfigurations(entityConfigurations);
        return this;
    }

    public YogaBuilder registerYogaMetaDataClasses(Class<?> ... classes) {
        this.setYogaMetaDataRegisteredClasses(classes);
        return this;
    }

    public YogaBuilder enableStarAsAllFields() {
        this.setEnableStarAsAllFields(true);
        return this;
    }

    public void finalize() {
        if (this._finalized) {
            return;
        }
        this.addAliases();
        if (this._createAllLinks) {
            this.registerRenderingListeners();
        }
        if (this._metaDataRegistry != null) {
            this.registerMetadataLinkListener();
        }
        this._finalized = true;
    }

    protected void registerMetadataLinkListener() {
        this._registry.addListener(new MetadataLinkListener(this.getMetaDataRegistry()));
    }

    protected void registerRenderingListeners() {
        UriGenerator uriGenerator = new UriGenerator(this._selectorResolver.getBaseSelector().getEntityConfigurationRegistry());
        this._registry.addListener(new HrefListener(uriGenerator));
        this._registry.addListener(new SelectorBuilderListener(uriGenerator));
        this._registry.addListener(new NavigationLinksListener(uriGenerator));
        this._registry.addListener(new ModelDefinitionListener());
    }

    protected void addAliases() {
        if (this._aliasProperties != null) {
            this._selectorResolver.getSelectorParser().setAliasSelectorResolver(new DynamicPropertyResolver(this._aliasProperties));
        }
    }
}

