/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.builder;

import org.skyscreamer.yoga.builder.YogaBuilder;
import org.skyscreamer.yoga.view.AbstractYogaView;
import org.skyscreamer.yoga.view.JsonSelectorView;
import org.skyscreamer.yoga.view.SelectorBuilderView;
import org.skyscreamer.yoga.view.StreamingJsonSelectorView;
import org.skyscreamer.yoga.view.XhtmlSelectorView;
import org.skyscreamer.yoga.view.XmlSelectorView;

public class YogaBuilderViewFactory {
    YogaBuilder builder;

    public YogaBuilderViewFactory() {
    }

    public YogaBuilderViewFactory(YogaBuilder builder) {
        this.builder = builder;
    }

    public void setBuilder(YogaBuilder builder) {
        this.builder = builder;
    }

    public XmlSelectorView createXmlSelectorView() {
        return this.injectViewDependencies(new XmlSelectorView());
    }

    public JsonSelectorView createJsonSelectorView() {
        return this.injectViewDependencies(new JsonSelectorView());
    }

    public StreamingJsonSelectorView createStreamingJsonSelectorView() {
        return this.injectViewDependencies(new StreamingJsonSelectorView());
    }

    public XhtmlSelectorView createXhtmlSelectorView() {
        return this.injectViewDependencies(new XhtmlSelectorView());
    }

    public SelectorBuilderView createSelectorBuilderView() {
        return this.injectViewDependencies(new SelectorBuilderView());
    }

    public <T extends AbstractYogaView> T injectViewDependencies(T yogaView) {
        this.builder.finalize();
        yogaView.setRegistry(this.builder.getRegistry());
        yogaView.setClassFinderStrategy(this.builder.getClassFinderStrategy());
        yogaView.setSelectorResolver(this.builder.getSelectorResolver());
        return yogaView;
    }
}

