/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.listener;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.skyscreamer.yoga.listener.HrefListener;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.listener.RenderingEventType;
import org.skyscreamer.yoga.listener.RenderingListener;
import org.skyscreamer.yoga.listener.UriGenerator;
import org.skyscreamer.yoga.model.MapHierarchicalModel;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.selector.parser.GDataSelectorParser;
import org.skyscreamer.yoga.selector.parser.LinkedInSelectorParser;
import org.skyscreamer.yoga.selector.parser.SelectorParser;

public class NavigationLinksListener
implements RenderingListener {
    private UriGenerator uriGenerator;

    public NavigationLinksListener() {
        this(new UriGenerator());
    }

    @Deprecated
    public NavigationLinksListener(HrefListener hrefListener) {
        this.setUriGenerator(hrefListener.getUriGenerator());
    }

    public NavigationLinksListener(UriGenerator uriGenerator) {
        this.setUriGenerator(uriGenerator);
    }

    @Deprecated
    public void setHrefListener(HrefListener hrefListener) {
        this.setUriGenerator(hrefListener.getUriGenerator());
    }

    public void setUriGenerator(UriGenerator uriGenerator) {
        this.uriGenerator = uriGenerator;
    }

    @Override
    public <T> void eventOccurred(RenderingEvent<T> event) throws IOException {
        String format;
        Selector selector = event.getSelector();
        if (event.getType() != RenderingEventType.POJO_CHILD || selector.isInfluencedExternally()) {
            return;
        }
        Class<T> instanceType = event.getValueType();
        T instance = event.getValue();
        String urlSuffix = event.getRequestContext().getUrlSuffix();
        MapHierarchicalModel<?> navigationLinks = ((MapHierarchicalModel)event.getModel()).createChildMap("navigationLinks");
        Collection<Property<T>> fieldNames = this.getNonSelectedFields(selector, instanceType, instance);
        SelectorParser selectorParser = event.getRequestContext().getSelectorParser();
        if (selectorParser instanceof LinkedInSelectorParser) {
            format = "%s?selector=:(%s)";
        } else if (selectorParser instanceof GDataSelectorParser) {
            format = "%s?selector=%s";
        } else {
            throw new IllegalStateException("Unknown selector type: " + selectorParser.getClass().getName());
        }
        for (Property<T> field : fieldNames) {
            String fieldName = field.name();
            MapHierarchicalModel<?> navModel = navigationLinks.createChildMap(fieldName);
            navModel.addProperty("href", this.uriGenerator.getUrl(event, String.format(format, urlSuffix, fieldName)));
            navModel.addProperty("name", fieldName);
            navModel.finished();
        }
        navigationLinks.finished();
    }

    public <T> Collection<Property<T>> getNonSelectedFields(Selector selector, Class<T> instanceType, Object instance) {
        HashMap<String, Property<T>> fields = new HashMap<String, Property<T>>(selector.getAllPossibleFieldMap(instanceType));
        for (Property<T> selected : selector.getSelectedFields(instanceType)) {
            fields.remove(selected.name());
        }
        return fields.values();
    }
}

