/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.listener;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.skyscreamer.yoga.annotations.URITemplate;
import org.skyscreamer.yoga.configuration.DefaultEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.listener.RenderingEvent;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.uri.URICreator;
import org.skyscreamer.yoga.uri.URIDecorator;
import org.skyscreamer.yoga.util.ValueReader;

public class UriGenerator {
    private EntityConfigurationRegistry _entityConfigurationRegistry = new DefaultEntityConfigurationRegistry();
    private ConcurrentHashMap<Class<?>, String> templates = new ConcurrentHashMap();

    public UriGenerator() {
    }

    public UriGenerator(EntityConfigurationRegistry _entityConfigurationRegistry) {
        this._entityConfigurationRegistry = _entityConfigurationRegistry;
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    public <T> String getUrl(RenderingEvent<T> event, String suffix) throws IOException {
        String urlTemplate = this.determineTemplate(event.getValueType());
        return urlTemplate != null ? this.getUrl(urlTemplate, suffix, event) : null;
    }

    public String determineTemplate(Class<?> instanceType) {
        String existing;
        YogaEntityConfiguration<?> entityConfiguration;
        String uriTemplate = this.templates.get(instanceType);
        if (uriTemplate != null) {
            return uriTemplate;
        }
        YogaEntityConfiguration<?> yogaEntityConfiguration = entityConfiguration = this._entityConfigurationRegistry == null ? null : this._entityConfigurationRegistry.getEntityConfiguration(instanceType);
        uriTemplate = entityConfiguration != null && entityConfiguration.getURITemplate() != null ? entityConfiguration.getURITemplate() : (instanceType.isAnnotationPresent(URITemplate.class) ? instanceType.getAnnotation(URITemplate.class).value() : this.determineTemplateForUnknownType(instanceType));
        if (uriTemplate != null && (existing = this.templates.putIfAbsent(instanceType, uriTemplate)) != null) {
            uriTemplate = existing;
        }
        return uriTemplate;
    }

    protected String determineTemplateForUnknownType(Class<?> instanceType) {
        return null;
    }

    public <T> String getUrl(String uriTemplate, String suffix, RenderingEvent<T> event) {
        String url = this.getUrlVal(uriTemplate, suffix, event);
        return event.getRequestContext().getResponse().encodeURL(url);
    }

    protected <T> String getUrlVal(String uriTemplate, final String suffix, final RenderingEvent<T> event) {
        ValueReader reader = new ValueReader(){

            @Override
            public Object getValue(String propertyName) {
                Property property = event.getSelector().getProperty(event.getValueType(), propertyName);
                return property == null ? null : property.getValue(event.getValue());
            }
        };
        if (suffix != null) {
            return URICreator.getHref(uriTemplate, reader, new URIDecorator(){

                @Override
                public StringBuilder decorate(StringBuilder uri) {
                    return uri.append(".").append(suffix);
                }
            });
        }
        return URICreator.getHref(uriTemplate, reader, new URIDecorator[0]);
    }
}

