/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.skyscreamer.yoga.selector.CoreSelector;
import org.skyscreamer.yoga.selector.FieldSelector;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class CompositeSelector
implements Selector {
    protected final CoreSelector coreSelector;
    protected final FieldSelector fieldSelector;

    public CompositeSelector(CoreSelector coreSelector, FieldSelector fieldSelector) {
        this.coreSelector = coreSelector;
        this.fieldSelector = fieldSelector;
    }

    @Override
    public Selector getChildSelector(Class<?> instanceType, String fieldName) {
        Selector fieldSelectorChild = this.fieldSelector.getChildSelector((Class)instanceType, fieldName);
        if (fieldSelectorChild == null) {
            return this.coreSelector;
        }
        return new CompositeSelector(this.coreSelector, (FieldSelector)fieldSelectorChild);
    }

    @Override
    public boolean containsField(Class<?> instanceType, String property) {
        return this.coreSelector.containsField(instanceType, property) || this.fieldSelector.containsField(instanceType, property);
    }

    @Override
    public <T> Property<T> getProperty(Class<T> instanceType, String fieldName) {
        Property<T> property = this.coreSelector.getProperty(instanceType, fieldName);
        return property != null ? property : this.fieldSelector.getProperty(instanceType, fieldName);
    }

    @Override
    public <T> Collection<Property<T>> getSelectedFields(Class<T> instanceType) {
        ArrayList<Property<T>> list = new ArrayList<Property<T>>();
        for (Property<T> p : this.fieldSelector.getSelectedFields(instanceType)) {
            Property<T> property = this.coreSelector.getProperty(instanceType, p.name());
            if (property == null) continue;
            list.add(property);
        }
        Collection<Property<T>> coreFields = this.coreSelector.getSelectedFields(instanceType);
        if (coreFields != null) {
            list.addAll(coreFields);
        }
        return list;
    }

    @Override
    public <T> Map<String, Property<T>> getAllPossibleFieldMap(Class<T> instanceType) {
        return this.coreSelector.getAllPossibleFieldMap(instanceType);
    }

    @Override
    public boolean isInfluencedExternally() {
        return true;
    }
}

