/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.skyscreamer.yoga.annotations.Core;
import org.skyscreamer.yoga.annotations.ExtraField;
import org.skyscreamer.yoga.configuration.EntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.NullEntityConfigurationRegistry;
import org.skyscreamer.yoga.configuration.YogaEntityConfiguration;
import org.skyscreamer.yoga.metadata.PropertyUtil;
import org.skyscreamer.yoga.selector.ExtraFieldProperty;
import org.skyscreamer.yoga.selector.PojoProperty;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.selector.Selector;

public class CoreSelector
implements Selector {
    private EntityConfigurationRegistry _entityConfigurationRegistry;
    protected final ConcurrentHashMap<Class, Map> _coreFields = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Class, Map> _allFields = new ConcurrentHashMap();

    public CoreSelector(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    public CoreSelector() {
        this._entityConfigurationRegistry = new NullEntityConfigurationRegistry();
    }

    public void setEntityConfigurationRegistry(EntityConfigurationRegistry entityConfigurationRegistry) {
        this._entityConfigurationRegistry = entityConfigurationRegistry;
    }

    public EntityConfigurationRegistry getEntityConfigurationRegistry() {
        return this._entityConfigurationRegistry;
    }

    @Override
    public <T> Property<T> getProperty(Class<T> instanceType, String fieldName) {
        Map<String, Property<T>> properties = this.getAllPossibleFieldMap(instanceType);
        return properties != null ? properties.get(fieldName) : null;
    }

    private <T> Map<String, Property<T>> getProperties(Class<T> instanceType, ConcurrentHashMap map) {
        Map<String, Property<T>> existingProperties;
        Map<String, Property<T>> properties = (Map<String, Property<T>>)map.get(instanceType);
        if (properties == null && (existingProperties = map.putIfAbsent(instanceType, properties = this.createCoreFieldsCollection(instanceType))) != null) {
            properties = existingProperties;
        }
        return properties;
    }

    private <T> Map<String, Property<T>> createCoreFieldsCollection(Class<T> instanceType) {
        Collection<Property<T>> properties;
        HashMap<String, Property<T>> response = new HashMap<String, Property<T>>();
        List<PropertyDescriptor> readableProperties = PropertyUtil.getReadableProperties(instanceType);
        YogaEntityConfiguration<T> config = this.getConfig(instanceType);
        Collection<String> allowedCoreFields = config != null ? config.getCoreFields() : null;
        Collection<Property<T>> collection = properties = config == null ? null : config.getProperties();
        if (allowedCoreFields == null) {
            for (PropertyDescriptor descriptor : readableProperties) {
                if (!descriptor.getReadMethod().isAnnotationPresent(Core.class)) continue;
                response.put(descriptor.getName(), this.createProperty(properties, instanceType, descriptor));
            }
        } else {
            for (PropertyDescriptor descriptor : readableProperties) {
                if (!allowedCoreFields.contains(descriptor.getName())) continue;
                response.put(descriptor.getName(), this.createProperty(properties, instanceType, descriptor));
            }
        }
        return response;
    }

    protected <T> Property<T> createProperty(Collection<Property<T>> properties, Class<T> instanceType, PropertyDescriptor desc) {
        if (properties != null) {
            for (Property<T> property : properties) {
                if (!property.name().equals(desc.getName())) continue;
                return property;
            }
        }
        return new PojoProperty(desc);
    }

    private <T> YogaEntityConfiguration<T> getConfig(Class<T> instanceType) {
        return this._entityConfigurationRegistry != null ? this._entityConfigurationRegistry.getEntityConfiguration(instanceType) : null;
    }

    @Override
    public <T> Map<String, Property<T>> getAllPossibleFieldMap(Class<T> instanceType) {
        Map<String, Property<T>> existing;
        Map<String, Property<T>> response = this._allFields.get(instanceType);
        if (response == null && (existing = this._allFields.putIfAbsent(instanceType, response = this.createAllFieldMap(instanceType))) != null) {
            response = existing;
        }
        return response;
    }

    protected <T> Map<String, Property<T>> createAllFieldMap(Class<T> instanceType) {
        TreeMap<String, Property<T>> response = new TreeMap<String, Property<T>>();
        YogaEntityConfiguration<T> config = this.getConfig(instanceType);
        List<PropertyDescriptor> getters = PropertyUtil.getReadableProperties(instanceType);
        TreeMap<String, Property<T>> getterMap = new TreeMap<String, Property<T>>();
        Collection<Property<T>> properties = config == null ? null : config.getProperties();
        for (PropertyDescriptor descriptor : getters) {
            String name = descriptor.getName();
            getterMap.put(name, this.createProperty(properties, instanceType, descriptor));
        }
        if (config != null) {
            Collection<String> selectableFields;
            response.putAll(this.getProperties(instanceType, this._coreFields));
            Collection<String> collection = selectableFields = config == null ? null : config.getSelectableFields();
            if (selectableFields != null) {
                for (String field : selectableFields) {
                    response.put(field, (Property<T>)getterMap.get(field));
                }
            } else {
                response = getterMap;
            }
            for (Method method : config.getExtraFieldMethods()) {
                String name = method.getAnnotation(ExtraField.class).value();
                response.put(name, new ExtraFieldProperty<T>(name, config, method));
            }
        } else {
            return getterMap;
        }
        return response;
    }

    @Override
    public <T> Collection<Property<T>> getSelectedFields(Class<T> instanceType) {
        return this.getProperties(instanceType, this._coreFields).values();
    }

    @Override
    public boolean containsField(Class<?> instanceType, String fieldName) {
        return this.getAllPossibleFieldMap(instanceType).containsKey(fieldName);
    }

    @Override
    public boolean isInfluencedExternally() {
        return false;
    }

    @Override
    public Selector getChildSelector(Class<?> instanceType, String fieldName) {
        return this;
    }
}

