/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.selector;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.skyscreamer.yoga.exceptions.YogaRuntimeException;
import org.skyscreamer.yoga.selector.Property;
import org.skyscreamer.yoga.util.ObjectUtil;

public class PojoProperty<T>
implements Property<T> {
    private PropertyDescriptor property;
    private Method readMethod;
    private boolean isPrimitive;

    public PojoProperty(PropertyDescriptor property) {
        this.property = property;
        this.readMethod = property.getReadMethod();
        this.isPrimitive = ObjectUtil.isPrimitive(this.readMethod.getReturnType());
    }

    @Override
    public String name() {
        return this.property.getName();
    }

    @Override
    public Object getValue(T instance) {
        try {
            return this.readMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new YogaRuntimeException("Could not read " + this.property.getName() + " from " + instance, e);
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public boolean isPrimitive() {
        return this.isPrimitive;
    }
}

