/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.util;

import java.io.IOException;
import java.io.OutputStream;
import org.skyscreamer.yoga.view.json.GeneratorAdapter;
import org.skyscreamer.yoga.view.json.Jackson2JsonGeneratorAdapter;
import org.skyscreamer.yoga.view.json.Jackson2Serializer;
import org.skyscreamer.yoga.view.json.JacksonJsonGeneratorAdapter;
import org.skyscreamer.yoga.view.json.JacksonSerializer;
import org.skyscreamer.yoga.view.json.JsonSerializer;

public class JacksonLibraryUtil {
    public static final String SYSTEM_PROPERTY = "yoga.jackson-library";
    public static final String JACKSON = "jackson";
    public static final String JACKSON2 = "jackson2";
    public static final boolean jackson2Present = JacksonLibraryUtil.classIsPresent("com.fasterxml.jackson.databind.ObjectMapper", JacksonLibraryUtil.class.getClassLoader()) && JacksonLibraryUtil.classIsPresent("com.fasterxml.jackson.core.JsonGenerator", JacksonLibraryUtil.class.getClassLoader());
    public static final boolean jacksonPresent = JacksonLibraryUtil.classIsPresent("org.codehaus.jackson.map.ObjectMapper", JacksonLibraryUtil.class.getClassLoader()) && JacksonLibraryUtil.classIsPresent("org.codehaus.jackson.JsonGenerator", JacksonLibraryUtil.class.getClassLoader());

    private static boolean classIsPresent(String className, ClassLoader classLoader) {
        try {
            if (classLoader == null) {
                Class.forName(className);
            } else {
                classLoader.loadClass(className);
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static JsonSerializer selectJacksonSerializer() {
        String property = System.getProperty(SYSTEM_PROPERTY);
        if (jackson2Present && (property == null || property.equals(JACKSON2))) {
            return new Jackson2Serializer();
        }
        if (jacksonPresent && (property == null || property.equals(JACKSON))) {
            return new JacksonSerializer();
        }
        throw new IllegalStateException("Jackson library not in classpath");
    }

    public static GeneratorAdapter selectGeneratorAdapter(OutputStream os) throws IOException {
        String property = System.getProperty(SYSTEM_PROPERTY);
        if (jackson2Present && (property == null || property.equals(JACKSON2))) {
            return new Jackson2JsonGeneratorAdapter(os);
        }
        if (jacksonPresent && (property == null || property.equals(JACKSON))) {
            return new JacksonJsonGeneratorAdapter(os);
        }
        throw new IllegalStateException("Jackson Library not in classpath");
    }
}

