/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.util;

import org.skyscreamer.yoga.exceptions.ParseSelectorException;

public class ParenthesisUtil {
    public static int getMatchingParenthesisIndex(CharSequence selector, int index) throws ParseSelectorException {
        return ParenthesisUtil.getMatchingBracketIndex(selector, index, '(', ')');
    }

    private static int getMatchingBracketIndex(CharSequence selector, int index, char openBracket, char closeBracket) throws ParseSelectorException {
        if (selector.charAt(index) != openBracket) {
            throw new ParseSelectorException("Selector does not have an opening bracket at index " + index);
        }
        int parenthesesCount = 1;
        while (parenthesesCount > 0 && index < selector.length() - 1) {
            if (selector.charAt(++index) == openBracket) {
                ++parenthesesCount;
            }
            if (selector.charAt(index) != closeBracket) continue;
            --parenthesesCount;
        }
        if (parenthesesCount > 0) {
            throw new ParseSelectorException("More opening brackets than closing brackets");
        }
        return index;
    }
}

