/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.skyscreamer.yoga.mapper.YogaRequestContext;
import org.skyscreamer.yoga.model.HierarchicalModel;
import org.skyscreamer.yoga.model.ObjectListHierarchicalModelImpl;
import org.skyscreamer.yoga.model.ObjectMapHierarchicalModelImpl;
import org.skyscreamer.yoga.util.JacksonLibraryUtil;
import org.skyscreamer.yoga.view.AbstractYogaView;
import org.skyscreamer.yoga.view.json.JsonSerializer;

public class JsonSelectorView
extends AbstractYogaView {
    private JsonSerializer jsonSerializer;

    public JsonSelectorView() {
        this.jsonSerializer = JacksonLibraryUtil.selectJacksonSerializer();
    }

    public JsonSelectorView(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    @Override
    public void render(Object value, YogaRequestContext requestContext, OutputStream outputStream) throws IOException {
        HierarchicalModel<Map<String, Object>> model;
        if (value instanceof Iterable) {
            ObjectListHierarchicalModelImpl listModel = new ObjectListHierarchicalModelImpl();
            this._resultTraverser.traverseIterable((Iterable)value, requestContext.getSelector(), listModel, requestContext);
            model = listModel;
        } else {
            ObjectMapHierarchicalModelImpl mapModel = new ObjectMapHierarchicalModelImpl();
            this._resultTraverser.traversePojo(value, requestContext.getSelector(), mapModel, requestContext);
            model = mapModel;
        }
        this.jsonSerializer.serialize(outputStream, model.getUnderlyingModel());
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getHrefSuffix() {
        return "json";
    }

    public void setSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }
}

