/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.util.Collections;
import java.util.Map;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.yoga.demo.test.AbstractTest;

public class AlbumControllerTest
extends AbstractTest {
    @Test
    public void testGetAlbum() throws Exception {
        JSONObject data = this.getJSONObject("/album/1", null);
        Assert.assertEquals((Object)"Funeral", (Object)data.getString("title"));
        Assert.assertEquals((long)1L, (long)data.getLong("id"));
        Assert.assertEquals((long)2004L, (long)data.getInt("year"));
        this.testForNavigationLinks(data, "/album/1.json", "artist", "songs");
    }

    @Test
    public void testGetArtist() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(artist)");
        JSONObject data = this.getJSONObject("/album/1", params);
        Assert.assertEquals((Object)"Arcade Fire", (Object)data.getJSONObject("artist").getString("name"));
        data = this.getJSONObject("/album/5", params);
        Assert.assertEquals((Object)"Prince", (Object)data.getJSONObject("artist").getString("name"));
        data = this.getJSONObject("/album/8", params);
        Assert.assertEquals((Object)"Neutral Milk Hotel", (Object)data.getJSONObject("artist").getString("name"));
    }

    @Test
    public void testGetSongs() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(songs)");
        JSONObject data = this.getJSONObject("/album/1", params);
        Assert.assertEquals((Object)"Haiti", (Object)data.getJSONArray("songs").getJSONObject(2).getString("title"));
        data = this.getJSONObject("/album/5", params);
        Assert.assertEquals((Object)"When Doves Cry", (Object)data.getJSONArray("songs").getJSONObject(1).getString("title"));
        data = this.getJSONObject("/album/8", params);
        Assert.assertEquals((Object)"Two-Headed Boy", (Object)data.getJSONArray("songs").getJSONObject(1).getString("title"));
    }
}

