/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.util.Collections;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.yoga.demo.test.AbstractTest;

public class ArtistControllerTest
extends AbstractTest {
    @Test
    public void testGetUser() throws Exception {
        JSONObject data = this.getJSONObject("/artist/1", null);
        Assert.assertEquals((Object)"Arcade Fire", (Object)data.getString("name"));
        Assert.assertEquals((long)1L, (long)data.getLong("id"));
        this.testForNavigationLinks(data, "/artist/1.json", "albums", "fans");
    }

    @Test
    public void testGetFans() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(fans)");
        JSONObject data = this.getJSONObject("/artist/1", params);
        JSONArray fans = data.getJSONArray("fans");
        data = this.getJSONObject("/artist/2", params);
        fans = data.getJSONArray("fans");
        Assert.assertEquals((Object)"Corby Page", (Object)fans.getJSONObject(0).getString("name"));
        data = this.getJSONObject("/artist/3", params);
        fans = data.getJSONArray("fans");
        Assert.assertEquals((Object)"Carter Page", (Object)fans.getJSONObject(0).getString("name"));
    }

    @Test
    public void getAlbums() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(albums)");
        JSONObject data = this.getJSONObject("/artist/1", params);
        JSONArray albums = data.getJSONArray("albums");
        Assert.assertEquals((long)3L, (long)albums.length());
        Assert.assertEquals((Object)"The Suburbs", (Object)albums.getJSONObject(2).getString("title"));
        data = this.getJSONObject("/artist/2", params);
        albums = data.getJSONArray("albums");
        Assert.assertEquals((Object)"Purple Rain", (Object)albums.getJSONObject(1).getString("title"));
        data = this.getJSONObject("/artist/3", params);
        albums = data.getJSONArray("albums");
        Assert.assertEquals((Object)"In the Aeroplane over the Sea", (Object)albums.getJSONObject(1).getString("title"));
    }
}

