/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.util.Collections;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.yoga.demo.test.AbstractTest;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class UserControllerTest
extends AbstractTest {
    public void testGetUser() throws Exception {
        JSONObject data = this.getJSONObject("/user/2", null);
        Assert.assertEquals((Object)"Corby Page", (Object)data.getString("name"));
        Assert.assertEquals((long)2L, (long)data.getLong("id"));
        Assert.assertEquals((Object)"/user/2.json", (Object)data.getString("href"));
        this.testForNavigationLinks(data, "/user/2.json", "friends", "favoriteArtists", "isFriend");
    }

    public void testGetNonExistentUser() throws Exception {
        try {
            this.getJSONObject("/user/8675309", null);
            Assert.fail((String)"HttpServerErrorException expected.");
        }
        catch (HttpClientErrorException e) {
            Assert.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)e.getStatusCode());
        }
    }

    public void testGetUsers() throws Exception {
        JSONArray data = this.getJSONArray("/user", null);
        JSONObject carter = data.getJSONObject(0);
        Assert.assertEquals((Object)"Carter Page", (Object)carter.getString("name"));
        Assert.assertEquals((long)1L, (long)carter.getLong("id"));
        Assert.assertEquals((Object)"/user/1.json", (Object)carter.getString("href"));
        this.testForNavigationLinks(carter, "/user/1.json", "friends", "favoriteArtists", "isFriend");
        JSONObject corby = data.getJSONObject(1);
        Assert.assertEquals((Object)"Corby Page", (Object)corby.getString("name"));
        Assert.assertEquals((long)2L, (long)corby.getLong("id"));
        Assert.assertEquals((Object)"/user/2.json", (Object)corby.getString("href"));
        this.testForNavigationLinks(corby, "/user/2.json", "friends", "favoriteArtists", "isFriend");
    }

    public void testGetUserWithSelector() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(isFriend)");
        JSONObject data = this.getJSONObject("/user/1", params);
        this.checkCarter(data);
        Assert.assertFalse((boolean)data.getBoolean("isFriend"));
    }

    public void testGetUserWithFriends() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(friends)");
        JSONObject data = this.getJSONObject("/user/1", params);
        this.checkCarter(data);
        JSONArray friends = data.getJSONArray("friends");
        JSONObject friend = friends.getJSONObject(0).getString("name").equals("Corby Page") ? friends.getJSONObject(0) : friends.getJSONObject(1);
        Assert.assertEquals((Object)"Corby Page", (Object)friend.getString("name"));
        Assert.assertEquals((Object)"/user/2.json", (Object)friend.getString("href"));
    }

    public void testGetUserWithFriendsAndSelector() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(friends:(isFriend))");
        JSONObject data = this.getJSONObject("/user/1", params);
        this.checkCarter(data);
        JSONArray friends = data.getJSONArray("friends");
        JSONObject friend = friends.getJSONObject(0).getString("name").equals("Corby Page") ? friends.getJSONObject(0) : friends.getJSONObject(1);
        this.checkCorby(friend);
        Assert.assertFalse((boolean)friend.getBoolean("isFriend"));
    }

    public void testDeepDiveSelector() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(friends:(favoriteArtists:(albums:(songs))))");
        JSONObject data = this.getJSONObject("/user/1", params);
        this.checkCarter(data);
        JSONArray friends = data.getJSONArray("friends");
        JSONObject friend = friends.getJSONObject(0).getString("name").equals("Corby Page") ? friends.getJSONObject(0) : friends.getJSONObject(1);
        this.checkCorby(friend);
        JSONArray favoriteArtists = friend.getJSONArray("favoriteArtists");
        JSONObject prince = "Prince".equals(favoriteArtists.getJSONObject(0).getString("name")) ? favoriteArtists.getJSONObject(0) : favoriteArtists.getJSONObject(1);
        JSONArray albums = prince.getJSONArray("albums");
        JSONObject prince1999 = albums.getJSONObject(0);
        JSONObject corvette = prince1999.getJSONArray("songs").getJSONObject(1);
        Assert.assertEquals((Object)"Little Red Corvette", (Object)corvette.getString("title"));
    }

    private void checkCorby(JSONObject data) throws JSONException {
        Assert.assertEquals((Object)"Corby Page", (Object)data.getString("name"));
        Assert.assertEquals((Object)"/user/2.json", (Object)data.getString("href"));
    }

    private void checkCarter(JSONObject data) throws JSONException {
        Assert.assertEquals((Object)"Carter Page", (Object)data.getString("name"));
        Assert.assertEquals((Object)"/user/1.json", (Object)data.getString("href"));
    }

    public void testRecommendedAlbums() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(recommendedAlbums)");
        JSONObject data = this.getJSONObject("/user/1", params);
        JSONArray recommended = data.getJSONArray("recommendedAlbums");
        Assert.assertNotNull((Object)recommended);
    }
}

