/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractTest {
    protected JSONObject getJSONObject(String url, Map<String, String> params) throws Exception {
        return new JSONObject(this.getContent(url, params));
    }

    protected JSONArray getJSONArray(String url, Map<String, String> params) throws Exception {
        return new JSONArray(this.getContent(url, params));
    }

    private String getContent(String url, Map<String, String> params) throws Exception, UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder sb = new StringBuilder("http://localhost:8082").append(url).append(".json");
        this.addParams(params, sb);
        return (String)restTemplate.getForObject(sb.toString(), String.class, new Object[0]);
    }

    private void addParams(Map<String, String> params, StringBuilder sb) {
        if (params == null) {
            return;
        }
        String append = "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(append).append(entry.getKey()).append("=").append(entry.getValue());
        }
    }

    protected void testForNavigationLinks(JSONObject data, String href, String ... propertyNames) throws Exception {
        JSONObject navigationLinks = data.getJSONObject("navigationLinks");
        Assert.assertEquals((long)navigationLinks.length(), (long)propertyNames.length);
        for (String propertyName : propertyNames) {
            JSONObject link = navigationLinks.getJSONObject(propertyName);
            Assert.assertEquals((long)2L, (long)link.length());
            Assert.assertEquals((Object)propertyName, (Object)link.getString("name"));
            Assert.assertEquals((Object)(href + "?selector=:(" + propertyName + ")"), (Object)link.getString("href"));
        }
    }
}

