/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.util.Collections;
import java.util.Map;
import org.json.JSONObject;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.yoga.demo.test.AbstractTest;

public class AlbumControllerTest
extends AbstractTest {
    @Test
    public void testGetAlbum() throws Exception {
        JSONObject data = this.getJSONObject("/album/1", null);
        String expected = "{id:1,title:\"Funeral\",year:\"2004\",navigationLinks:{artist:{name:\"artist\",href:\"/album/1.json?selector=:(artist)\"},songs:{name:\"songs\",href:\"/album/1.json?selector=:(songs)\"}}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testGetArtist() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(artist)");
        JSONObject data = this.getJSONObject("/album/1", params);
        String expected = "{artist:{name:\"Arcade Fire\"}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
        data = this.getJSONObject("/album/5", params);
        expected = "{artist:{name:\"Prince\"}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
        data = this.getJSONObject("/album/8", params);
        expected = "{artist:{name:\"Neutral Milk Hotel\"}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testGetSongs() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(songs)");
        JSONObject data = this.getJSONObject("/album/1", params);
        String expected = "{songs:[{title:\"Neighborhood #1 (Tunnels)\"},{title:\"Wake Up\"},{title:\"Haiti\"}]}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }
}

