/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test;

import java.util.Collections;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.yoga.demo.test.TestUtil;

public class UserControllerTest {
    @Test
    public void testGetUser() throws Exception {
        JSONObject data = TestUtil.getJSONObject("/user/2", null);
        String expected = "{id:2,name:\"Corby Page\",navigationLinks:{friends:{name:\"friends\",href:\"/user/friends/2.json\"},favoriteArtists:{name:\"favoriteArtists\",href:\"/user/favoriteArtists/2.json\"},isFriend:{name:\"isFriend\",href:\"/user/isFriend/2.json\"}}}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testGetNonExistentUser() throws Exception {
        try {
            TestUtil.getJSONObject("/user/8675309", null);
            Assert.fail((String)"HttpServerErrorException expected.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetUsers() throws Exception {
        JSONArray data = TestUtil.getJSONArray("/user", null);
        Assert.assertEquals((long)1003L, (long)data.length());
    }

    @Test
    public void testGetUserWithSelector() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(isFriend)");
        JSONObject data = TestUtil.getJSONObject("/user/1", params);
        String expected = "{id:1,name:\"Carter Page\",href:\"/user/1.json\",isFriend:false}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testGetUserWithFriends() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(friends)");
        JSONObject data = TestUtil.getJSONObject("/user/1", params);
        String expected = "{id:1,name:\"Carter Page\",href:\"/user/1.json\",friends:[{id:2,name:\"Corby Page\",href:\"/user/2.json\"},{id:3,name:\"Solomon Duskis\",href:\"/user/3.json\"}]}";
        System.out.println(data);
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testDeepDiveSelector() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(isFriend,friends:(favoriteArtists:(albums:(songs))))");
        JSONObject data = TestUtil.getJSONObject("/user/1", params);
        System.out.println(data);
        String expected = "{id:1,name:\"Carter Page\",href:\"/user/1.json\",isFriend:false,friends:[{id:2,name:\"Corby Page\",href:\"/user/2.json\",favoriteArtists:[{id:2,name:\"Prince\",albums:[{id:4,title:\"1999\",songs:[{id:10},{id:11,title:\"Little Red Corvette\"},{id:12}]},{id:5},{id:6}]},{id:1}]},{id:3}]}";
        JSONAssert.assertEquals((String)expected, (JSONObject)data, (boolean)false);
    }

    @Test
    public void testRecommendedAlbums() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(recommendedAlbums)");
        JSONObject data = TestUtil.getJSONObject("/user/1", params);
        JSONArray recommended = data.getJSONArray("recommendedAlbums");
        Assert.assertNotNull((Object)recommended);
    }

    @Test
    public void testGetTooMuchData() throws Exception {
        Map<String, String> params = Collections.singletonMap("selector", ":(friends:(favoriteArtists))");
        try {
            TestUtil.getJSONObject("/user", params);
        }
        catch (Exception e) {
            String message = e.getMessage();
            Assert.assertNotNull((Object)message);
            return;
        }
        Assert.fail((String)"Expected this query to fail with a 500 error caused by an EntityCountExceededException");
    }
}

