/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.model;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.skyscreamer.yoga.annotations.Core;
import org.skyscreamer.yoga.annotations.URITemplate;
import org.skyscreamer.yoga.demo.model.Artist;
import org.skyscreamer.yoga.demo.model.Song;

@Entity
@URITemplate(value="/album/{id}")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class Album {
    @Id
    @GeneratedValue
    private long id;
    private String title;
    private int year;
    @ManyToOne
    @JoinColumn(name="artistId")
    private Artist artist;
    @OneToMany(mappedBy="album")
    @OrderBy(value="id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private List<Song> songs;

    @Core
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Core
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Artist getArtist() {
        return this.artist;
    }

    public void setArtist(Artist artist) {
        this.artist = artist;
    }

    @Core
    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public List<Song> getSongs() {
        return this.songs;
    }

    public void setSongs(List<Song> songs) {
        this.songs = songs;
    }
}

