/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.dao.inmemory;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import org.skyscreamer.yoga.demo.model.Album;
import org.skyscreamer.yoga.demo.model.Artist;
import org.skyscreamer.yoga.demo.model.Song;
import org.skyscreamer.yoga.demo.model.User;

public class DemoData {
    private Map<Long, User> users = Maps.newHashMap();
    private Map<Long, Artist> artists = Maps.newHashMap();
    private Map<Long, Album> albums = Maps.newHashMap();
    private Map<Long, Song> songs = Maps.newHashMap();
    public static final String remoteData = "https://raw.github.com/skyscreamer/skyscreamer.github.com/master/yoga/loaddb.sql.gz";
    public static final String localData = "sampledb.sql";

    public void init() {
        try {
            this.init(Thread.currentThread().getContextClassLoader().getResourceAsStream(localData));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String type = line.replaceFirst("INSERT INTO ([^(]+).*", "$1");
            String[] values = line.replaceFirst(".*VALUES\\((.*)\\)", "$1").split(", ");
            if ("User".equalsIgnoreCase(type)) {
                this.newUser(this.toLong(values[0]), this.toStr(values[1]));
                continue;
            }
            if ("Friend".equalsIgnoreCase(type)) {
                this.newFriend(this.toLong(values[0]), this.toLong(values[1]));
                continue;
            }
            if ("Artist".equalsIgnoreCase(type)) {
                this.newArtist(this.toLong(values[0]), this.toStr(values[1]));
                continue;
            }
            if ("Fan".equalsIgnoreCase(type)) {
                this.newFan(this.toLong(values[0]), this.toLong(values[1]));
                continue;
            }
            if ("Album".equalsIgnoreCase(type)) {
                this.newAlbum(this.toLong(values[0]), this.toStr(values[1]), this.toLong(values[2]), new Integer(values[3].trim()));
                continue;
            }
            if (!"Song".equalsIgnoreCase(type)) continue;
            this.newSong(this.toLong(values[0]), this.toStr(values[1]), this.toLong(values[2]), this.toLong(values[3]));
        }
        is.close();
    }

    private long toLong(String string) {
        return Long.parseLong(string.trim());
    }

    private String toStr(String string) {
        return string.trim().replaceFirst("^'", "").replaceFirst("'$", "");
    }

    private void newUser(long id, String name) {
        User user = new User();
        user.setName(name);
        user.setId(id);
        this.users.put(id, user);
    }

    private void newFriend(long from, long to) {
        this.users.get(from).getFriends().add(this.users.get(to));
    }

    private void newArtist(long id, String name) {
        Artist artist = new Artist();
        artist.setId(id);
        artist.setName(name);
        this.artists.put(id, artist);
    }

    private void newFan(long userId, long artistId) {
        Artist artist = this.artists.get(artistId);
        User user = this.users.get(userId);
        user.getFavoriteArtists().add(artist);
        artist.getFans().add(user);
    }

    private void newAlbum(long id, String title, long artistId, int year) {
        Album album = new Album();
        album.setId(id);
        album.setTitle(title);
        Artist artist = this.artists.get(artistId);
        album.setArtist(artist);
        album.setYear(year);
        this.albums.put(id, album);
        artist.getAlbums().add(album);
    }

    private void newSong(long id, String title, long artistId, long albumId) {
        Song song = new Song();
        song.setId(id);
        song.setTitle(title);
        song.setArtist(this.artists.get(artistId));
        Album album = this.albums.get(albumId);
        song.setAlbum(album);
        album.getSongs().add(song);
        this.songs.put(id, song);
    }

    protected <T> Map<Long, T> getMap(Class<T> type) {
        if (type == User.class) {
            return this.users;
        }
        if (type == Album.class) {
            return this.albums;
        }
        if (type == Song.class) {
            return this.songs;
        }
        if (type == Artist.class) {
            return this.artists;
        }
        throw new IllegalArgumentException("you cannot get a map for type: " + type.getName());
    }

    public <T> T get(Class<T> type, long id) {
        return this.getMap(type).get(id);
    }

    public <T> Collection<T> getAll(Class<T> type) {
        return this.getMap(type).values();
    }
}

