/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test.controller;

import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.skyscreamer.yoga.metadata.MetaDataService;
import org.skyscreamer.yoga.metadata.TypeMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/metadata"})
public class MetaDataController {
    @Autowired
    MetaDataService metaDataService;

    @RequestMapping
    public Map<String, String> getTypes() {
        TreeMap<String, String> response = new TreeMap<String, String>();
        for (String type : this.metaDataService.getTypes()) {
            response.put(type, "/metadata/" + type);
        }
        return response;
    }

    @RequestMapping(value={"/{type}"})
    public TypeMetaData getTypeMetaData(@PathVariable(value="type") String type, HttpServletRequest request) {
        String uri = request.getRequestURI();
        String[] parts = uri.split("\\.");
        return this.metaDataService.getMetaData(type, parts[parts.length - 1]);
    }
}

