/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.demo.test.controller;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.ObjectNotFoundException;
import org.skyscreamer.yoga.demo.dao.GenericDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractController<T> {
    @Autowired
    GenericDao _genericDao;
    Class<T> _entityClass = this.returnedClass();

    @RequestMapping(value={"/{id}"})
    public T get(@PathVariable long id) {
        return (T)this._genericDao.find(this._entityClass, id);
    }

    @RequestMapping
    public List<T> getAll() {
        return this._genericDao.findAll(this._entityClass);
    }

    @RequestMapping(value={"/count"})
    @ResponseBody
    public String getCount(ModelAndView mv) {
        return String.valueOf(this._genericDao.getCount(this._entityClass));
    }

    private Class<T> returnedClass() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    @ExceptionHandler(value={ObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such resource")
    public void notFound() {
    }
}

