/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.resteasy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.spring.ResteasyRegistration;
import org.jboss.resteasy.plugins.spring.SpringResourceFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class RESTEasySpringListener
implements SmartApplicationListener {
    @Autowired
    ConfigurableListableBeanFactory beanFactory;
    @Autowired
    protected Registry registry;
    @Autowired
    protected ResteasyProviderFactory providerFactory;
    @Autowired
    protected Dispatcher dispatcher;

    public void onApplicationEvent(ApplicationEvent event) {
        this.beanFactory.registerResolvableDependency(Registry.class, (Object)this.registry);
        this.beanFactory.registerResolvableDependency(ResteasyProviderFactory.class, (Object)this.providerFactory);
        if (this.dispatcher != null) {
            this.beanFactory.registerResolvableDependency(Dispatcher.class, (Object)this.dispatcher);
        }
        Collection<String> ignoreList = this.createRestEasyRegistrations(this.beanFactory);
        ArrayList<SpringResourceFactory> springResourceFactories = new ArrayList<SpringResourceFactory>();
        for (String name : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef;
            if (ignoreList.contains(name) || (beanDef = this.beanFactory.getBeanDefinition(name)).getBeanClassName() == null || beanDef.isAbstract()) continue;
            Class<?> beanClass = this.getBeanClass(beanDef);
            if (beanClass.isAnnotationPresent(Provider.class)) {
                Object bean = this.beanFactory.getBean(name);
                this.providerFactory.getInjectorFactory().createPropertyInjector(beanClass).inject(bean);
                this.providerFactory.registerProviderInstance(bean);
            }
            if (!GetRestful.isRootResource(beanClass)) continue;
            springResourceFactories.add(new SpringResourceFactory(name, (BeanFactory)this.beanFactory, beanClass));
        }
        for (ResourceFactory resourceFactory : springResourceFactories) {
            this.registry.addResourceFactory(resourceFactory);
        }
    }

    protected Class<?> getBeanClass(BeanDefinition beanDef) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(beanDef.getBeanClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOrder() {
        return 1000;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == ContextRefreshedEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return ApplicationContext.class.isAssignableFrom(sourceType);
    }

    private Collection<String> createRestEasyRegistrations(ConfigurableListableBeanFactory beanFactory) {
        Map registries = beanFactory.getBeansOfType(ResteasyRegistration.class);
        HashSet<String> resteasyRegistrations = new HashSet<String>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (ResteasyRegistration registration : registries.values()) {
            String beanName = registration.getBeanName();
            resteasyRegistrations.add(beanName);
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            try {
                Class<?> beanClass = contextClassLoader.loadClass(beanDef.getBeanClassName());
                SpringResourceFactory reg = new SpringResourceFactory(beanName, (BeanFactory)beanFactory, beanClass);
                this.registry.addResourceFactory((ResourceFactory)reg, registration.getContext());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return resteasyRegistrations;
    }
}

