/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.springmvc.view;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.skyscreamer.yoga.mapper.HierarchicalModel;
import org.skyscreamer.yoga.mapper.MapHierarchicalModel;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.springmvc.view.AbstractYogaView;

public class JsonSelectorView
extends AbstractYogaView {
    @Override
    public void render(OutputStream outputStream, Selector selector, Object value) throws IOException {
        Object viewData;
        if (value instanceof Iterable) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (Object instance : (Iterable)value) {
                list.add(this.getSingleResult(instance, selector));
            }
            viewData = list;
        } else {
            viewData = this.getSingleResult(value, selector);
        }
        this.getObjectMapper().writeValue(outputStream, viewData);
    }

    protected ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }

    protected Map<String, Object> getSingleResult(Object value, Selector selector) {
        MapHierarchicalModel model = new MapHierarchicalModel();
        this.resultTraverser.traverse(value, selector, (HierarchicalModel)model, this.getHrefSuffix());
        return model.getObjectTree();
    }

    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getHrefSuffix() {
        return "json";
    }
}

