/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.springmvc.view;

import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.skyscreamer.yoga.mapper.HierarchicalModel;
import org.skyscreamer.yoga.mapper.XmlHierarchyModel;
import org.skyscreamer.yoga.selector.Selector;
import org.skyscreamer.yoga.springmvc.view.AbstractYogaView;
import org.skyscreamer.yoga.util.NameUtil;

public class XmlSelectorView
extends AbstractYogaView {
    @Override
    public void render(OutputStream outputStream, Selector selector, Object value) throws IOException {
        DOMDocument domDocument = new DOMDocument();
        if (value instanceof Iterable) {
            DOMElement root = this.createDocument(domDocument, "result");
            XmlHierarchyModel model = new XmlHierarchyModel((Element)root);
            for (Object child : (Iterable)value) {
                this.resultTraverser.traverse(child, selector, (HierarchicalModel)model, this.getHrefSuffix());
            }
        } else {
            String name = NameUtil.getName((Class)this.resultTraverser.findClass(value));
            DOMElement root = this.createDocument(domDocument, name);
            this.resultTraverser.traverse(value, selector, (HierarchicalModel)new XmlHierarchyModel((Element)root), this.getHrefSuffix());
        }
        XmlSelectorView.write(outputStream, domDocument);
    }

    public DOMElement createDocument(DOMDocument domDocument, String name) {
        DOMElement root = new DOMElement(name);
        domDocument.setRootElement((Element)root);
        return root;
    }

    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getHrefSuffix() {
        return "xml";
    }
}

