/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.yoga.springmvc.view;

import java.lang.reflect.Method;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class YogaModelAndViewResolverAdapter
implements ModelAndViewResolver {
    ViewResolver viewResolver;
    boolean requireResponseBodyAnnotation = false;

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    public void setRequireResponseBodyAnnotation(boolean requireResponseBodyAnnotation) {
        this.requireResponseBodyAnnotation = requireResponseBodyAnnotation;
    }

    public ModelAndView resolveModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, NativeWebRequest webRequest) {
        if (returnValue == null || returnValue instanceof String) {
            return ModelAndViewResolver.UNRESOLVED;
        }
        if (this.requireResponseBodyAnnotation && !handlerMethod.isAnnotationPresent(ResponseBody.class)) {
            return ModelAndViewResolver.UNRESOLVED;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            View view = this.viewResolver.resolveViewName("yoga", locale);
            return view == null ? ModelAndViewResolver.UNRESOLVED : new ModelAndView(view, "value", returnValue);
        }
        catch (Exception e) {
            throw new RuntimeException("could not process request", e);
        }
    }
}

