package org.slimecraft.bedrock.minecraft.item;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import java.util.ArrayList;

public class BedrockItemBuilder {
    private final BedrockItem item = new BedrockItem();

    public BedrockItemBuilder addMaterial(Material material) {
        item.setMaterial(material);
        return this;
    }

    public BedrockItemBuilder addAmount(int amount) {
        item.setAmount(amount);
        return this;
    }

    public BedrockItemBuilder addName(Component name) {
        item.setName(name.decoration(TextDecoration.ITALIC, false));
        return this;
    }

    public BedrockItemBuilder addName(Component name, boolean italic) {
        if (italic) {
            item.setName(name.decoration(TextDecoration.ITALIC, true));
        }
        return this;
    }

    public BedrockItemBuilder addLore(Component... lore) {
        if (item.getLore() == null) {
            item.setLore(new ArrayList<>());
        }
        for (Component loreLine : lore) {
            item.getLore().add(loreLine.decoration(TextDecoration.ITALIC, false));
        }
        return this;
    }

    public BedrockItemBuilder addLore(boolean italic, Component... lore) {
        if (item.getLore() == null) {
            item.setLore(new ArrayList<>());
        }
        for (Component loreLine : lore) {
            item.getLore().add(loreLine.decoration(TextDecoration.ITALIC, true));
        }
        return this;
    }

    public ItemStack build() {
        ItemStack normalItem = new ItemStack(item.getMaterial(), item.getAmount());
        ItemMeta normalItemMeta = normalItem.getItemMeta();
        normalItemMeta.displayName(item.getName());
        normalItemMeta.lore(item.getLore());
        normalItem.setItemMeta(normalItemMeta);

        return normalItem;
    }
}
