package org.slimecraft.bedrock.minecraft.scoreboard;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.*;
import org.slimecraft.bedrock.minecraft.text.BedrockText;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BedrockScoreboardBuilder {
    private final BedrockScoreboard scoreboard = new BedrockScoreboard();

    public BedrockScoreboardBuilder addTitle(Component title) {
        scoreboard.setTitle(title);
        return this;
    }

    public BedrockScoreboardBuilder addLine(Component... lines) {
        if (scoreboard.getLines() == null) {
            scoreboard.setLines(new ArrayList<>());
        }
        for (Component line : lines) {
            scoreboard.getLines().add(line);
        }
        return this;
    }

    public BedrockScoreboardBuilder addUpdateTicks(long updateTicks) {
        scoreboard.setUpdateTicks(updateTicks);
        return this;
    }

    public Scoreboard build() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard normalScoreboard = manager.getNewScoreboard();

        Component scoreBoardTitle = scoreboard.getTitle();
        String scoreBoardTitleSerialized = PlainTextComponentSerializer.plainText().serialize(scoreBoardTitle);

        try {
            Objective objective = normalScoreboard.registerNewObjective(scoreBoardTitleSerialized, Criteria.DUMMY, scoreBoardTitle, RenderType.INTEGER);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);

            List<Score> scores = new ArrayList<>();
            List<Component> lines = scoreboard.getLines();
            Collections.reverse(lines);

            for (int i = 0; i < lines.size(); i++) {
                scores.add(objective.getScore("" + i));
                scores.get(i).setScore(i);
                scores.get(i).customName(lines.get(i));
                Bukkit.getScheduler().runTaskTimer(JavaPlugin.getProvidingPlugin(Plugin.class), this::updateScoreBoard, scoreboard.getUpdateTicks(), scoreboard.getUpdateTicks());
            }
        } catch (IllegalArgumentException e) {
            ComponentLogger.logger().error(BedrockText.text("<red>Scoreboard \"" + scoreBoardTitleSerialized + "\" has a scoreboard with the same name!"));
        }
        return normalScoreboard;
    }

    private void updateScoreBoard() {

    }

}
