package org.slimecraft.bedrock.minecraft.test;

import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slimecraft.bedrock.minecraft.item.BedrockItem;
import org.slimecraft.bedrock.minecraft.text.BedrockText;

public class TestCommand implements CommandExecutor {
    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {

        if (!(sender instanceof Player player)) return true;
        if (args.length == 0) {
            player.sendMessage(BedrockText.text("<red>You must provide arguments to this command!"));
            return true;
        }

        String firstArg = args[0].toLowerCase();

        if ("bedrock".equals(firstArg)) {
            ItemStack bedrock = BedrockItem.builder()
                    .addMaterial(Material.BEDROCK)
                    .addName(BedrockText.text("<gray>Bedrock"))
                    .addLore(BedrockText.text("<yellow>This is an"))
                    .addLore(BedrockText.text("<red>epic piece of bedrock<white>!"))
                    .addAmount(10)
                    .build();
            giveItemToPlayer(player, bedrock);
        }
        else if ("pog".equals(firstArg)) {
            ItemStack pog = BedrockItem.builder()
                    .addMaterial(Material.AMETHYST_SHARD)
                    .addName(BedrockText.text("<light_purple>Poggie Item"))
                    .addLore(BedrockText.text("<green>POGCHAMP!!!"))
                    .addAmount(30)
                    .build();
            giveItemToPlayer(player, pog);
        }
        return true;
    }

    private void giveItemToPlayer(Player player, ItemStack item) {
        player.getInventory().addItem(item);
    }
}
