/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slingerxv.limitart.funcs.Test2;
import org.slingerxv.limitart.util.StringUtil;

public class ConstraintMap<K> {
    private Map<K, Object> map;

    protected ConstraintMap(Map<K, Object> map) {
        this.map = Objects.requireNonNull(map, "map");
    }

    protected ConstraintMap() {
        this.map = new HashMap<K, Object>();
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public ConstraintMap<K> putByte(K key, byte value) {
        this.putObj(key, value);
        return this;
    }

    public byte getByte(K key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        return Byte.valueOf(this.getObj(key).toString());
    }

    public ConstraintMap<K> putShort(K key, short value) {
        this.putObj(key, value);
        return this;
    }

    public short getShort(K key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        return Short.valueOf(this.getObj(key).toString());
    }

    public ConstraintMap<K> putInt(K key, int value) {
        this.putObj(key, value);
        return this;
    }

    public int getInt(K key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        return Integer.valueOf(this.getObj(key).toString());
    }

    public ConstraintMap<K> putLong(K key, long value) {
        this.putObj(key, value);
        return this;
    }

    public long getLong(K key) {
        if (!this.containsKey(key)) {
            return 0L;
        }
        return Long.valueOf(this.getObj(key).toString());
    }

    public ConstraintMap<K> putFloat(K key, float value) {
        this.putObj(key, Float.valueOf(value));
        return this;
    }

    public float getFloat(K key) {
        if (!this.containsKey(key)) {
            return 0.0f;
        }
        return Float.valueOf(this.getObj(key).toString()).floatValue();
    }

    public ConstraintMap<K> putDouble(K key, double value) {
        this.putObj(key, value);
        return this;
    }

    public double getDouble(K key) {
        if (!this.containsKey(key)) {
            return 0.0;
        }
        return Double.valueOf(this.getObj(key).toString());
    }

    public ConstraintMap<K> putChar(K key, char value) {
        this.putObj(key, Character.valueOf(value));
        return this;
    }

    public char getChar(K key) {
        if (!this.containsKey(key)) {
            return '\u0000';
        }
        return ((Character)this.getObj(key)).charValue();
    }

    public ConstraintMap<K> putBoolean(K key, boolean value) {
        this.putInt(key, value ? 1 : 0);
        return this;
    }

    public boolean getBoolean(K key) {
        return this.getInt(key) == 1;
    }

    public ConstraintMap<K> putString(K key, String value) {
        if (value == null) {
            this.putObj(key, "");
        } else {
            this.putObj(key, value);
        }
        return this;
    }

    public String getString(K key) {
        if (!this.containsKey(key)) {
            return "";
        }
        return (String)this.map.get(key);
    }

    public ConstraintMap<K> foreach(BiConsumer<? super K, ? super Object> action) {
        this.map.forEach(action);
        return this;
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public String toJSON() {
        return StringUtil.toJSON(this.map);
    }

    public String toJSONWithClassInfo() {
        return StringUtil.toJSONWithClassInfo(this.map);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(Objects.requireNonNull(key, "key"));
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(Objects.requireNonNull(value, "value"));
    }

    public ConstraintMap<K> putObj(K key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public <V> V getObj(K key) {
        return (V)this.map.get(key);
    }

    public ConstraintMap<K> remove(K key) {
        this.map.remove(Objects.requireNonNull(key, "key"));
        return this;
    }

    public ConstraintMap<K> remove(Test2<K, Object> filter) {
        Iterator<Map.Entry<K, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Object> next = iterator.next();
            if (!filter.test(next.getKey(), next.getValue())) continue;
            iterator.remove();
        }
        return this;
    }

    public ConstraintMap<K> putAll(Map<? extends K, ? extends Object> map) {
        this.map.putAll(Objects.requireNonNull(map, "map"));
        return this;
    }

    public ConstraintMap<K> putAll(ConstraintMap<K> map) {
        Objects.requireNonNull(map, "map");
        this.map.putAll(map.map);
        return this;
    }

    public static <K> ConstraintMap<K> fromJSON(String jsonContent) {
        ConstraintMap<K> map = new ConstraintMap<K>();
        if (!StringUtil.isEmptyOrNull(jsonContent)) {
            Map object = StringUtil.toObject(jsonContent, HashMap.class);
            map.putAll(object);
        }
        return map;
    }

    public static <K> ConstraintMap<K> empty() {
        return new ConstraintMap<K>();
    }

    public static <K> ConstraintMap<K> just(Object ... kvs) {
        Objects.requireNonNull(kvs, "kvs");
        ConstraintMap<Object> empty = ConstraintMap.empty();
        for (int i = 0; i < kvs.length; i += 2) {
            Objects.requireNonNull(kvs[i], "key");
            Objects.requireNonNull(kvs[i + 1], "value");
            empty.putObj(kvs[i], kvs[i + 1]);
        }
        return empty;
    }

    public static <K> ConstraintMap<K> from(Map<? extends K, ? extends Object> map) {
        ConstraintMap<? extends K> empty = ConstraintMap.empty();
        empty.putAll(map);
        return empty;
    }
}

