/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slingerxv.limitart.collections.IRankMap;
import org.slingerxv.limitart.funcs.Func;

public class FrequencyReadRankMap<K, V extends Func<K>>
implements IRankMap<K, V> {
    private List<V> list;
    private Map<K, V> map;
    private final Comparator<V> comparator;
    private int capacity;

    @Override
    public synchronized void clear() {
        this.list.clear();
        this.map.clear();
    }

    public FrequencyReadRankMap(Comparator<V> comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity > 0");
        }
        this.map = new HashMap(capacity);
        this.comparator = Objects.requireNonNull(comparator, "comparator");
        this.list = new ArrayList<V>(capacity);
        this.capacity = capacity;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int getIndex(K key) {
        if (!this.map.containsKey(key)) {
            return -1;
        }
        Func v = (Func)this.map.get(key);
        return this.binarySearch(v, false);
    }

    @Override
    public List<V> getAll() {
        return new ArrayList<V>(this.list);
    }

    @Override
    public List<V> getRange(int startIndex, int endIndex) {
        ArrayList<V> temp = new ArrayList<V>();
        int start = startIndex;
        int end = endIndex + 1;
        int size = this.size();
        if (size == 0) {
            return temp;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end >= size) {
            end = size - 1;
        }
        if (start == end) {
            V at = this.getAt(start);
            if (at != null) {
                temp.add(at);
            }
            return temp;
        }
        return this.list.subList(start, end);
    }

    @Override
    public V getAt(int at) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (at < 0) {
            return null;
        }
        if (at >= size) {
            return null;
        }
        return (V)((Func)this.list.get(at));
    }

    public String toString() {
        return this.list.toString();
    }

    private int binarySearch(V v, boolean similar) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Func midVal = (Func)this.list.get(mid);
            int cmp = this.comparator.compare(midVal, v);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (similar) {
            return low;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((Func)this.map.get(key));
    }

    @Override
    public synchronized V put(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.map.containsKey(key)) {
            Func obj = (Func)this.map.get(key);
            int compare = this.comparator.compare(value, obj);
            if (compare == 0) {
                return null;
            }
            int binarySearch = this.binarySearch(obj, false);
            this.list.remove(binarySearch);
        }
        int binarySearch = 0;
        if (this.size() > 0) {
            binarySearch = this.binarySearch(value, true);
        }
        this.map.put(key, value);
        this.list.add(binarySearch, value);
        while (this.map.size() > this.capacity) {
            Func pollLast = (Func)this.list.remove(this.map.size() - 1);
            this.map.remove(pollLast.run());
        }
        return value;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> requireNonNull = Objects.requireNonNull(map, "map");
        for (Map.Entry<K, V> entry : requireNonNull.entrySet()) {
            this.put(entry.getKey(), (V)((Func)entry.getValue()));
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

