/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.slingerxv.limitart.collections.IRankMap;
import org.slingerxv.limitart.funcs.Func;

public class FrequencyWriteRankMap<K, V extends Func<K>>
implements IRankMap<K, V> {
    private final TreeSet<V> treeSet;
    private final Map<K, V> map;
    private final Comparator<V> comparator;
    private final int capacity;
    private List<V> indexList;
    private boolean modified = false;

    public FrequencyWriteRankMap(Comparator<V> comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity > 0");
        }
        this.treeSet = new TreeSet<V>(comparator);
        this.map = new HashMap(capacity);
        this.comparator = Objects.requireNonNull(comparator, "comparator");
        this.capacity = capacity;
    }

    @Override
    public synchronized void clear() {
        this.treeSet.clear();
        this.map.clear();
        this.indexList = null;
        this.modified = true;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int getIndex(K key) {
        if (!this.map.containsKey(key)) {
            return -1;
        }
        Func v = (Func)this.map.get(key);
        this.checkModified();
        return Collections.binarySearch(this.indexList, v, this.comparator);
    }

    @Override
    public List<V> getAll() {
        this.checkModified();
        return new ArrayList<V>(this.indexList);
    }

    @Override
    public List<V> getRange(int startIndex, int endIndex) {
        ArrayList<V> temp = new ArrayList<V>();
        int size = this.size();
        int start = startIndex;
        int end = endIndex + 1;
        if (size == 0) {
            return temp;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end >= size) {
            end = size - 1;
        }
        if (start == end) {
            V at = this.getAt(start);
            if (at != null) {
                temp.add(at);
            }
            return temp;
        }
        this.checkModified();
        return this.indexList.subList(start, end);
    }

    @Override
    public V getAt(int at) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (at < 0) {
            return null;
        }
        if (at >= size) {
            return null;
        }
        if (at == 0) {
            return (V)((Func)this.treeSet.first());
        }
        if (at == this.size() - 1) {
            return (V)((Func)this.treeSet.last());
        }
        this.checkModified();
        return (V)((Func)this.indexList.get(at));
    }

    public String toString() {
        return this.treeSet.toString();
    }

    private synchronized void checkModified() {
        if (this.modified) {
            this.modified = false;
            this.indexList = new ArrayList<V>(this.treeSet);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((Func)this.map.get(key));
    }

    @Override
    public synchronized V put(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.map.containsKey(key)) {
            Func obj = (Func)this.map.get(key);
            if (this.comparator.compare(value, obj) == 0) {
                return null;
            }
            this.treeSet.remove(obj);
        }
        this.map.put(key, value);
        this.treeSet.add(value);
        this.modified = true;
        while (this.map.size() > this.capacity) {
            Func pollLast = (Func)this.treeSet.pollLast();
            this.map.remove(pollLast.run());
        }
        return value;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> requireNonNull = Objects.requireNonNull(map, "map");
        for (Map.Entry<K, V> entry : requireNonNull.entrySet()) {
            this.put(entry.getKey(), (V)((Func)entry.getValue()));
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

