/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.collections;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.funcs.Test2;
import org.slingerxv.limitart.funcs.Tests;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int cacheSize;
    private Proc2<Object, V> onRemove;
    private Test2<Object, V> canRemoveWithoutLRU;

    public LRUHashMap(int cacheSize) {
        super((int)Math.ceil((float)cacheSize / 0.75f) + 2, 0.75f, true);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.cacheSize || Tests.invoke(this.canRemoveWithoutLRU, eldest.getKey(), eldest.getValue())) {
            Procs.invoke(this.onRemove, eldest.getKey(), eldest.getValue());
            return true;
        }
        return false;
    }

    public LRUHashMap<K, V> onRemove(Proc2<Object, V> func) {
        this.onRemove = func;
        return this;
    }

    public LRUHashMap<K, V> canRemoveWithoutLRU(Test2<Object, V> func) {
        this.canRemoveWithoutLRU = func;
        return this;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : super.entrySet()) {
            Procs.invoke(this.onRemove, entry.getKey(), entry.getValue());
        }
        super.clear();
    }

    @Override
    public V remove(Object key) {
        Object remove = super.remove(key);
        if (remove != null) {
            Procs.invoke(this.onRemove, key, remove);
        }
        return remove;
    }
}

