/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.bag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slingerxv.limitart.funcs.Test1;
import org.slingerxv.limitart.game.bag.exception.BagFullException;
import org.slingerxv.limitart.game.bag.exception.BagGridOcuppiedException;
import org.slingerxv.limitart.game.bag.exception.ItemNotExistException;
import org.slingerxv.limitart.game.bag.exception.ItemNotSameTypeException;
import org.slingerxv.limitart.game.bag.exception.ItemOverStackException;
import org.slingerxv.limitart.game.bag.exception.ItemSliptNotEnoughNumException;
import org.slingerxv.limitart.game.bag.exception.ItemZeroNumException;
import org.slingerxv.limitart.game.item.AbstractItem;
import org.slingerxv.limitart.util.Beta;

@Beta
public abstract class Bag {
    private static final int START_GRID = 0;

    public void canAddItem(AbstractItem item) throws ItemZeroNumException, BagFullException, ItemNotExistException {
        if (item == null) {
            throw new ItemNotExistException();
        }
        if (item.getNum() <= 0) {
            throw new ItemZeroNumException();
        }
        if (this.remain() <= 0) {
            throw new BagFullException();
        }
    }

    public void canAddItems(List<AbstractItem> items) throws ItemZeroNumException, BagFullException, ItemNotExistException {
        if (items.isEmpty()) {
            throw new ItemNotExistException();
        }
        for (AbstractItem item : items) {
            if (item.getNum() > 0) continue;
            throw new ItemZeroNumException();
        }
        if (this.remain() < items.size()) {
            throw new BagFullException();
        }
    }

    public void addItem(int gridId, AbstractItem item) throws BagFullException, BagGridOcuppiedException, ItemZeroNumException, ItemNotExistException {
        if (gridId < 0 || gridId > this.capacity() - 1 || this.bag().containsKey(gridId)) {
            gridId = this.getAnEmptyGrid();
        }
        if (gridId == -1) {
            throw new BagFullException();
        }
        this.canAddItem(item);
        this.bag().put(gridId, item);
        this.onItemAdded(gridId, item);
    }

    public void addItem(AbstractItem item) throws BagFullException, BagGridOcuppiedException, ItemZeroNumException, ItemNotExistException {
        this.addItem(Integer.MIN_VALUE, item);
    }

    public void addItems(List<AbstractItem> items) throws BagFullException, BagGridOcuppiedException, ItemNotExistException, ItemZeroNumException {
        if (items.isEmpty()) {
            throw new ItemNotExistException();
        }
        this.canAddItems(items);
        for (AbstractItem item : items) {
            this.addItem(item);
        }
    }

    public AbstractItem removeItem(int gridId) {
        AbstractItem remove = this.bag().remove(gridId);
        if (remove != null) {
            this.onItemRemoved(gridId, remove);
        }
        return remove;
    }

    public List<AbstractItem> removeItems(Test1<AbstractItem> filter) {
        ArrayList<AbstractItem> result = new ArrayList<AbstractItem>();
        Iterator<Map.Entry<Integer, AbstractItem>> iterator = this.bag().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AbstractItem> next = iterator.next();
            if (!filter.test(next.getValue())) continue;
            iterator.remove();
            result.add(next.getValue());
            this.onItemRemoved(next.getKey(), next.getValue());
        }
        return result;
    }

    public AbstractItem getItem(int gridId) {
        return this.bag().get(gridId);
    }

    public List<AbstractItem> getItems(Test1<AbstractItem> filter) {
        ArrayList<AbstractItem> result = new ArrayList<AbstractItem>();
        for (AbstractItem item : this.bag().values()) {
            if (!filter.test(item)) continue;
            result.add(item);
        }
        return result;
    }

    public int getItemCount(Test1<AbstractItem> filter) {
        int count = 0;
        for (AbstractItem item : this.bag().values()) {
            if (!filter.test(item)) continue;
            count += item.getNum();
        }
        return count;
    }

    public synchronized void makeUp() {
        ConcurrentHashMap<Integer, AbstractItem> tempGrids = new ConcurrentHashMap<Integer, AbstractItem>();
        for (int i = 0; i < this.capacity(); ++i) {
            for (int j = i + 1; j < this.capacity(); ++j) {
                try {
                    this.merge(i, j);
                    continue;
                }
                catch (ItemNotExistException | ItemNotSameTypeException | ItemOverStackException | ItemZeroNumException e) {
                    // empty catch block
                }
            }
        }
        ArrayList<AbstractItem> tempList = new ArrayList<AbstractItem>(this.bag().values());
        Collections.sort(tempList);
        for (int i = 0; i < this.capacity(); ++i) {
            AbstractItem oldItem;
            AbstractItem newItem = null;
            if (i < tempList.size()) {
                newItem = (AbstractItem)tempList.get(i);
                tempGrids.put(i, newItem);
            }
            if (newItem == (oldItem = this.bag().get(i))) continue;
            if (oldItem != null) {
                this.onItemRemoved(i, oldItem);
            }
            if (newItem == null) continue;
            this.onItemAdded(i, newItem);
        }
        this.bag().clear();
        this.bag().putAll(tempGrids);
    }

    private void split(AbstractItem item, int num) throws ItemNotExistException, ItemSliptNotEnoughNumException, BagFullException, BagGridOcuppiedException, ItemZeroNumException {
        if (item == null) {
            throw new ItemNotExistException();
        }
        if (item.getNum() <= 1 || num > item.getNum()) {
            throw new ItemSliptNotEnoughNumException(item.getNum(), num);
        }
        int anEmptyGrid = this.getAnEmptyGrid();
        if (anEmptyGrid == -1) {
            throw new BagFullException();
        }
        int reduceNum = Math.max(1, num);
        item.setNum(item.getNum() - reduceNum);
        this.onItemChanged(item);
        AbstractItem copy = item.copy();
        copy.setNum(reduceNum);
        this.addItem(anEmptyGrid, copy);
    }

    public void split(int gridId, int num) throws ItemNotExistException, ItemSliptNotEnoughNumException, BagFullException, BagGridOcuppiedException, ItemZeroNumException {
        AbstractItem item = this.getItem(gridId);
        this.split(item, num);
        if (item.getNum() <= 0) {
            this.removeItem(gridId);
        }
    }

    private void merge(AbstractItem me, AbstractItem another) throws ItemNotSameTypeException, ItemOverStackException, ItemNotExistException, ItemZeroNumException {
        if (me == null || another == null) {
            throw new ItemNotExistException();
        }
        if (me.getNum() <= 0 || another.getNum() <= 0) {
            throw new ItemZeroNumException();
        }
        if (!me.isSameType(another)) {
            throw new ItemNotSameTypeException();
        }
        int meNum = me.getNum();
        int anotherNum = another.getNum();
        if (meNum >= me.getMaxStackNumber()) {
            throw new ItemOverStackException(me.getMaxStackNumber());
        }
        int meAfterNum = Math.min(me.getMaxStackNumber(), meNum + anotherNum);
        me.setNum(meAfterNum);
        this.onItemChanged(me);
        another.setNum(another.getNum() - (meAfterNum - meNum));
        this.onItemChanged(another);
    }

    public void merge(int gridOne, int gridAnother) throws ItemNotExistException, ItemNotSameTypeException, ItemOverStackException, ItemZeroNumException {
        AbstractItem me = this.getItem(gridOne);
        AbstractItem another = this.getItem(gridAnother);
        this.merge(me, another);
        if (another.getNum() <= 0) {
            this.removeItem(gridAnother);
        }
    }

    public int getAnEmptyGrid() {
        for (int i = 0; i < this.capacity(); ++i) {
            if (this.bag().get(i) != null) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.bag().size();
    }

    public int remain() {
        return Math.max(0, this.capacity() - this.size());
    }

    protected abstract Map<Integer, AbstractItem> bag();

    public abstract int capacity();

    protected abstract void onItemAdded(int var1, AbstractItem var2);

    protected abstract void onItemRemoved(int var1, AbstractItem var2);

    public abstract void onItemChanged(AbstractItem var1);
}

