/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.innerserver;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.game.innerserver.config.InnerFightServerConfig;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.distributed.InnerMasterServer;
import org.slingerxv.limitart.net.binary.distributed.InnerSlaveServer;
import org.slingerxv.limitart.net.binary.distributed.struct.InnerServerData;
import org.slingerxv.limitart.net.binary.distributed.util.InnerServerUtil;
import org.slingerxv.limitart.util.Beta;

@Beta
public abstract class InnerFightServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(InnerFightServer.class);
    private InnerMasterServer server;
    private InnerSlaveServer toMaster;

    public InnerFightServer(InnerFightServerConfig config) throws Exception {
        this.server = new InnerMasterServer.InnerMasterServerBuilder().serverName("Fight").masterPort(config.getFightServerInnerPort()).factory(config.getFactory()).onConnectionChanged((data, isConnected) -> {
            if (isConnected.booleanValue()) {
                if (data.getServerType() == 1) {
                    log.info("game server connected:" + data.getServerId() + ",cur size:" + this.server.getSlaves(1).size());
                } else {
                    log.error("server type :" + data.getServerType() + " connected!!!!!!!check!!!!");
                }
            }
        }).build();
        this.toMaster = new InnerSlaveServer.InnerSlaveServerBuilder().slaveName("Fight-To-Public").slaveType(2).myServerId(config.getServerId()).myServerIp(config.getFightServerIp()).myServerPort(config.getFightServerPort()).myServerPass(config.getFightServerPass()).masterServerPort(config.getFightServerPort()).myInnerServerPort(config.getFightServerInnerPort()).myInnerServerPass(InnerServerUtil.getInnerPass()).masterIp(config.getPublicIp()).masterInnerPort(config.getPublicPort()).masterInnerPass(InnerServerUtil.getInnerPass()).facotry(config.getFactory()).serverLoad(() -> this.getFightServerLoad()).onConnectMasterSuccess(slave -> {
            this.server.startServer();
            this.onConnectPublic((InnerSlaveServer)slave);
        }).build();
    }

    @Override
    public synchronized void startServer() {
        this.toMaster.startServer();
    }

    @Override
    public synchronized void stopServer() {
        this.toMaster.stopServer();
        this.server.stopServer();
    }

    protected abstract int getFightServerLoad();

    protected abstract void onConnectPublic(InnerSlaveServer var1);

    public InnerSlaveServer getPublicClient() {
        return this.toMaster;
    }

    public InnerServerData getGameServer(int serverId) {
        return this.server.getSlave(1, serverId);
    }

    public List<InnerServerData> getGameServers() {
        return this.server.getSlaves(1);
    }
}

