/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.innerserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.game.innerserver.config.InnerGameServerConfig;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.distributed.InnerSlaveServer;
import org.slingerxv.limitart.net.binary.distributed.util.InnerServerUtil;
import org.slingerxv.limitart.util.Beta;

@Beta
public abstract class InnerGameServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(InnerGameServer.class);
    private Map<Integer, InnerSlaveServer> toFights = new ConcurrentHashMap<Integer, InnerSlaveServer>();
    private InnerSlaveServer toPublic;

    public InnerGameServer(InnerGameServerConfig config) throws Exception {
        this.toPublic = new InnerSlaveServer.InnerSlaveServerBuilder().slaveName("Game-To-Public").myServerId(config.getServerId()).myServerIp(config.getGameServerIp()).myServerPort(config.getGameServerPort()).myServerPass(config.getGameServerPass()).masterIp(config.getPublicIp()).masterInnerPort(config.getPublicPort()).masterInnerPass(InnerServerUtil.getInnerPass()).facotry(config.getFactory()).slaveType(1).serverLoad(() -> this.getGameServerLoad()).onNewSlaveQuit((serverType, serverId) -> {
            if (serverType == 2) {
                // empty if block
            }
        }).onNewSlaveJoin(info -> {
            if (info.serverType == 2) {
                if (this.toFights.containsKey(info.serverId)) {
                    return;
                }
                try {
                    InnerSlaveServer client = new InnerSlaveServer.InnerSlaveServerBuilder().slaveName("Game-To-Fight").myServerId(config.getServerId()).myServerIp(config.getGameServerIp()).myServerPort(config.getGameServerPort()).myServerPass(config.getGameServerPass()).masterIp(info.outIp).masterServerPort(info.outPort).masterServerPass(info.outPass).masterInnerPort(info.innerPort).masterInnerPass(InnerServerUtil.getInnerPass()).facotry(config.getFactory()).slaveType(1).serverLoad(() -> this.getGameServerLoad()).onConnectMasterSuccess(slave -> {
                        InnerServerUtil.setServerType(slave.getMasterClient().channel(), 2);
                        InnerServerUtil.setServerId(slave.getMasterClient().channel(), innerServerInfo.serverId);
                    }).build();
                    this.toFights.put(info.serverId, client);
                    client.startServer();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }).onConnectMasterSuccess(slave -> this.onConnectPublic((InnerSlaveServer)slave)).build();
    }

    protected abstract int getGameServerLoad();

    protected abstract void onConnectPublic(InnerSlaveServer var1);

    @Override
    public synchronized void startServer() {
        this.toPublic.startServer();
    }

    @Override
    public synchronized void stopServer() {
        this.toPublic.stopServer();
    }

    public InnerSlaveServer getPublicClient() {
        return this.toPublic;
    }

    public InnerSlaveServer getFightClient(int serverId) {
        return this.toFights.get(serverId);
    }

    public List<InnerSlaveServer> getFightClients() {
        return new ArrayList<InnerSlaveServer>(this.toFights.values());
    }
}

