/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.innerserver.config;

import java.util.Objects;
import org.slingerxv.limitart.net.binary.message.MessageFactory;

public class InnerGameServerConfig {
    private int serverId;
    private String gameServerIp;
    private int gameServerPort;
    private String gameServerPass;
    private String publicIp;
    private int publicPort;
    private MessageFactory factory;

    private InnerGameServerConfig(InnerGameServerConfigBuilder builder) {
        this.serverId = builder.serverId;
        this.gameServerIp = builder.gameServerIp;
        this.gameServerPort = builder.gameServerPort;
        this.gameServerPass = builder.gameServerPass;
        this.publicIp = builder.publicIp;
        this.publicPort = builder.publicPort;
        this.factory = Objects.requireNonNull(builder.factory, "factory");
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getGameServerIp() {
        return this.gameServerIp;
    }

    public int getGameServerPort() {
        return this.gameServerPort;
    }

    public String getGameServerPass() {
        return this.gameServerPass;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public static class InnerGameServerConfigBuilder {
        private int serverId;
        private String gameServerIp;
        private int gameServerPort;
        private String gameServerPass;
        private String publicIp;
        private int publicPort;
        private MessageFactory factory;

        public InnerGameServerConfig build() {
            return new InnerGameServerConfig(this);
        }

        public InnerGameServerConfigBuilder serverId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public InnerGameServerConfigBuilder gameServerIp(String gameServerIp) {
            this.gameServerIp = gameServerIp;
            return this;
        }

        public InnerGameServerConfigBuilder gameServerPort(int gameServerPort) {
            if (gameServerPort >= 1024) {
                this.gameServerPort = gameServerPort;
            }
            return this;
        }

        public InnerGameServerConfigBuilder gameServerPass(String gameServerPass) {
            this.gameServerPass = gameServerPass;
            return this;
        }

        public InnerGameServerConfigBuilder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public InnerGameServerConfigBuilder publicPort(int publicPort) {
            if (publicPort >= 1024) {
                this.publicPort = publicPort;
            }
            return this;
        }

        public InnerGameServerConfigBuilder factory(MessageFactory factory) {
            this.factory = factory;
            return this;
        }
    }
}

