/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.org;

import org.slingerxv.limitart.game.org.IAuth;
import org.slingerxv.limitart.game.org.exception.AuthIDDuplicatedException;
import org.slingerxv.limitart.game.org.exception.AuthIDErrorException;

public class Job {
    public static final transient int NONE_JOB_ID = 0;
    public static final transient int DEFAULT_MAX_MEMBER = 10;
    public static final transient int DEFAULT_JOB_CLASS = 0;
    private int jobId = 0;
    private int jobClass = 0;
    private String jobName;
    private int maxMember = 10;
    private int auth = 0;

    public void addAuthes(IAuth ... auths) throws AuthIDErrorException, AuthIDDuplicatedException {
        if (auths != null) {
            for (IAuth temp : auths) {
                if (temp == null) continue;
                if (temp.getAuthID() < 0 || temp.getAuthID() > 32) {
                    throw new AuthIDErrorException("auth id must between 0~32,your id:" + temp.getAuthID());
                }
                int authValue = 1 << temp.getAuthID();
                if ((this.auth & authValue) == authValue) {
                    throw new AuthIDDuplicatedException("auth id duplicated:" + temp.getAuthID());
                }
                this.auth |= authValue;
            }
        }
    }

    public void addAuth(IAuth auth) throws AuthIDErrorException {
        if (auth.getAuthID() < 0 || auth.getAuthID() > 32) {
            throw new AuthIDErrorException("auth id must between 0~32,your id:" + auth.getAuthID());
        }
        this.auth |= 1 << auth.getAuthID();
    }

    public void removeAuth(IAuth auth) throws AuthIDErrorException {
        if (auth.getAuthID() < 0 || auth.getAuthID() > 32) {
            throw new AuthIDErrorException("auth id must between 0~32,your id:" + auth.getAuthID());
        }
        int mask = ~(1 << auth.getAuthID());
        this.auth &= mask;
    }

    public boolean hasAuth(IAuth auth) throws AuthIDErrorException {
        if (auth.getAuthID() < 0 || auth.getAuthID() > 32) {
            throw new AuthIDErrorException("auth id must between 0~32,your id:" + auth.getAuthID());
        }
        int value = 1 << auth.getAuthID();
        return (value & this.auth) == value;
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public int getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(int jobClass) {
        this.jobClass = jobClass;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public int getMaxMember() {
        return this.maxMember;
    }

    public void setMaxMember(int maxMember) {
        this.maxMember = maxMember;
    }

    public int getAuth() {
        return this.auth;
    }

    public void setAuth(int auth) {
        this.auth = auth;
    }
}

